/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.DriverProxy;
import io.aeron.LogBuffersFactory;
import io.aeron.MappedLogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SleepingIdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class Aeron
implements AutoCloseable {
    public static final ErrorHandler DEFAULT_ERROR_HANDLER = throwable -> {
        throwable.printStackTrace();
        if (throwable instanceof DriverTimeoutException) {
            System.err.printf("%n***%n*** Timeout from the Media Driver - is it currently running? Exiting.%n***%n", new Object[0]);
            System.exit(-1);
        }
    };
    public static final long IDLE_SLEEP_NS = TimeUnit.MILLISECONDS.toNanos(10L);
    public static final long KEEPALIVE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
    public static final long INTER_SERVICE_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final long PUBLICATION_CONNECTION_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(5L);
    private boolean isClosed = false;
    private final ClientConductor conductor;
    private final AgentRunner conductorRunner;
    private final Context ctx;

    Aeron(Context ctx) {
        ctx.conclude();
        this.ctx = ctx;
        this.conductor = new ClientConductor(ctx.epochClock, ctx.nanoClock, ctx.toClientBuffer, ctx.logBuffersFactory, ctx.countersValuesBuffer(), new DriverProxy(ctx.toDriverBuffer), ctx.errorHandler, ctx.availableImageHandler, ctx.unavailableImageHandler, ctx.imageMapMode, ctx.keepAliveInterval(), ctx.driverTimeoutMs(), ctx.interServiceTimeout(), ctx.publicationConnectionTimeout());
        this.conductorRunner = new AgentRunner(ctx.idleStrategy, ctx.errorHandler, null, (Agent)this.conductor);
    }

    public static Aeron connect() {
        return new Aeron(new Context()).start();
    }

    public static Aeron connect(Context ctx) {
        return new Aeron(ctx).start();
    }

    @Override
    public void close() {
        this.conductor.mainLock().lock();
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.conductorRunner.close();
                this.ctx.close();
            }
        }
        finally {
            this.conductor.mainLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publication addPublication(String channel, int streamId) {
        this.conductor.mainLock().lock();
        try {
            if (this.isClosed) {
                throw new IllegalStateException("Aeron client is closed");
            }
            Publication publication = this.conductor.addPublication(channel, streamId);
            return publication;
        }
        finally {
            this.conductor.mainLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription addSubscription(String channel, int streamId) {
        this.conductor.mainLock().lock();
        try {
            if (this.isClosed) {
                throw new IllegalStateException("Aeron client is closed");
            }
            Subscription subscription = this.conductor.addSubscription(channel, streamId);
            return subscription;
        }
        finally {
            this.conductor.mainLock().unlock();
        }
    }

    public CountersReader countersReader() {
        this.conductor.mainLock().lock();
        try {
            if (this.isClosed) {
                throw new IllegalStateException("Aeron client is closed");
            }
            CountersReader countersReader = new CountersReader((AtomicBuffer)this.ctx.countersMetaDataBuffer(), (AtomicBuffer)this.ctx.countersValuesBuffer());
            return countersReader;
        }
        finally {
            this.conductor.mainLock().unlock();
        }
    }

    private Aeron start() {
        AgentRunner.startOnThread((AgentRunner)this.conductorRunner, (ThreadFactory)this.ctx.threadFactory);
        return this;
    }

    public static class Context
    extends CommonContext {
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private IdleStrategy idleStrategy;
        private CopyBroadcastReceiver toClientBuffer;
        private RingBuffer toDriverBuffer;
        private MappedByteBuffer cncByteBuffer;
        private AtomicBuffer cncMetaDataBuffer;
        private LogBuffersFactory logBuffersFactory;
        private ErrorHandler errorHandler;
        private AvailableImageHandler availableImageHandler;
        private UnavailableImageHandler unavailableImageHandler;
        private long keepAliveInterval = KEEPALIVE_INTERVAL_NS;
        private long interServiceTimeout = INTER_SERVICE_TIMEOUT_NS;
        private long publicationConnectionTimeout = PUBLICATION_CONNECTION_TIMEOUT_MS;
        private FileChannel.MapMode imageMapMode;
        private ThreadFactory threadFactory = Thread::new;

        @Override
        public Context conclude() {
            super.conclude();
            if (null == this.epochClock) {
                this.epochClock = new SystemEpochClock();
            }
            if (null == this.nanoClock) {
                this.nanoClock = new SystemNanoClock();
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new SleepingIdleStrategy(IDLE_SLEEP_NS);
            }
            if (this.cncFile() != null) {
                this.connectToDriver();
            }
            if (null == this.toClientBuffer) {
                BroadcastReceiver receiver = new BroadcastReceiver((AtomicBuffer)CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                this.toClientBuffer = new CopyBroadcastReceiver(receiver);
            }
            if (null == this.toDriverBuffer) {
                this.toDriverBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            if (this.countersMetaDataBuffer() == null) {
                this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            if (this.countersValuesBuffer() == null) {
                this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            this.interServiceTimeout = CncFileDescriptor.clientLivenessTimeout((DirectBuffer)this.cncMetaDataBuffer);
            if (null == this.logBuffersFactory) {
                this.logBuffersFactory = new MappedLogBuffersFactory();
            }
            if (null == this.errorHandler) {
                this.errorHandler = DEFAULT_ERROR_HANDLER;
            }
            if (null == this.availableImageHandler) {
                this.availableImageHandler = image -> {};
            }
            if (null == this.unavailableImageHandler) {
                this.unavailableImageHandler = image -> {};
            }
            if (null == this.imageMapMode) {
                this.imageMapMode = FileChannel.MapMode.READ_ONLY;
            }
            return this;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public Context toClientBuffer(CopyBroadcastReceiver toClientBuffer) {
            this.toClientBuffer = toClientBuffer;
            return this;
        }

        public Context toDriverBuffer(RingBuffer toDriverBuffer) {
            this.toDriverBuffer = toDriverBuffer;
            return this;
        }

        public Context bufferManager(LogBuffersFactory logBuffersFactory) {
            this.logBuffersFactory = logBuffersFactory;
            return this;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Context availableImageHandler(AvailableImageHandler handler) {
            this.availableImageHandler = handler;
            return this;
        }

        public Context unavailableImageHandler(UnavailableImageHandler handler) {
            this.unavailableImageHandler = handler;
            return this;
        }

        public Context keepAliveInterval(long value) {
            this.keepAliveInterval = value;
            return this;
        }

        public long keepAliveInterval() {
            return this.keepAliveInterval;
        }

        @Override
        public Context driverTimeoutMs(long value) {
            super.driverTimeoutMs(value);
            return this;
        }

        public long interServiceTimeout() {
            return this.interServiceTimeout;
        }

        @Override
        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        public Context publicationConnectionTimeout(long value) {
            this.publicationConnectionTimeout = value;
            return this;
        }

        public long publicationConnectionTimeout() {
            return this.publicationConnectionTimeout;
        }

        public Context imageMapMode(FileChannel.MapMode imageMapMode) {
            this.imageMapMode = imageMapMode;
            return this;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        @Override
        public void close() {
            IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
            super.close();
        }

        private void connectToDriver() {
            int cncVersion;
            long startMs = this.epochClock.time();
            File cncFile = this.cncFile();
            while (!cncFile.exists()) {
                if (this.epochClock.time() > startMs + this.driverTimeoutMs()) {
                    throw new DriverTimeoutException("CnC file not found: " + cncFile.getName());
                }
                LockSupport.parkNanos(1L);
            }
            this.cncByteBuffer = IoUtil.mapExistingFile((File)this.cncFile(), (String)"cnc.dat");
            this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(this.cncByteBuffer);
            while (0 == (cncVersion = this.cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0)))) {
                if (this.epochClock.time() > startMs + this.driverTimeoutMs()) {
                    throw new DriverTimeoutException("CnC file is created by not initialised.");
                }
                LockSupport.parkNanos(1L);
            }
            if (5 != cncVersion) {
                throw new IllegalStateException("Aeron CnC file version not supported: version=" + cncVersion);
            }
        }
    }
}

