/*
 * Decompiled with CFR 0.152.
 */
package scalax.file.ramfs;

import java.net.URI;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WeakHashMap;
import scala.collection.mutable.WeakHashMap$;
import scala.runtime.BoxesRunTime;
import scalax.file.ramfs.RamFileSystem;
import scalax.file.ramfs.RamFileSystem$RamFsId$;
import scalax.file.ramfs.RamPath;
import scalax.io.DefaultResourceContext$;
import scalax.io.ResourceContext;

public final class RamFileSystem$ {
    public static final RamFileSystem$ MODULE$;
    private final String protocol;
    private final WeakHashMap<RamFileSystem.RamFsId, RamFileSystem> fileSystems;

    static {
        new RamFileSystem$();
    }

    public String protocol() {
        return this.protocol;
    }

    private WeakHashMap<RamFileSystem.RamFsId, RamFileSystem> fileSystems() {
        return this.fileSystems;
    }

    public RamFileSystem apply(String separator) {
        RamFileSystem.RamFsId x$5 = this.$lessinit$greater$default$1();
        ResourceContext x$6 = this.$lessinit$greater$default$3();
        return new RamFileSystem(x$5, separator, x$6);
    }

    public synchronized RamFileSystem apply(RamFileSystem.RamFsId fsId) {
        Object object;
        Option option = this.fileSystems().get((Object)fsId);
        if (!option.isEmpty()) {
            object = option.get();
        } else {
            RamFileSystem$ ramFileSystem$ = this;
            RamFileSystem$ ramFileSystem$2 = this;
            object = new RamFileSystem(fsId, "/", (ResourceContext)DefaultResourceContext$.MODULE$);
        }
        return (RamFileSystem)object;
    }

    public RamPath apply(URI uri) {
        String string = uri.toString();
        Predef$ predef$ = Predef$.MODULE$;
        boolean bl = new StringOps(string).contains((Object)BoxesRunTime.boxToCharacter((char)'!'));
        Predef$ predef$2 = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringBuilder().append((Object)"Ramfile system URIs must be of form: ramfs://fsId!path, was: ").append((Object)uri).append((Object)" (did not contain a !)").toString()).toString());
        }
        boolean bl2 = uri.getScheme().equalsIgnoreCase("ramfs");
        Predef$ predef$3 = Predef$.MODULE$;
        if (!bl2) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringBuilder().append((Object)"Ramfile system URIs must start with ramfs, was: ").append((Object)uri).toString()).toString());
        }
        String string2 = uri.getAuthority();
        Predef$ predef$4 = Predef$.MODULE$;
        RamFileSystem.RamFsId id = new RamFileSystem.RamFsId((String)new StringOps(string2).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 != '!';
            }
        }));
        RamFileSystem fs = this.apply(id);
        String path = uri.getRawPath().replace("/", fs.separator());
        return fs.fromString(path);
    }

    public String apply$default$1() {
        return "/";
    }

    public synchronized void scalax$file$ramfs$RamFileSystem$$register(RamFileSystem.RamFsId fsId, RamFileSystem fs) {
        this.fileSystems().update((Object)fsId, (Object)fs);
    }

    public RamFileSystem.RamFsId $lessinit$greater$default$1() {
        return new RamFileSystem.RamFsId(RamFileSystem$RamFsId$.MODULE$.apply$default$1());
    }

    public String $lessinit$greater$default$2() {
        return "/";
    }

    public ResourceContext $lessinit$greater$default$3() {
        return DefaultResourceContext$.MODULE$;
    }

    private RamFileSystem$() {
        MODULE$ = this;
        this.protocol = "ramfs";
        this.fileSystems = (WeakHashMap)WeakHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

