/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public class DirectPublication
implements DriverManagedResource {
    private static final ReadablePosition[] EMPTY_POSITIONS = new ReadablePosition[0];
    private final long correlationId;
    private final long tripGain;
    private long tripLimit = 0L;
    private final int sessionId;
    private final int streamId;
    private final int termWindowLength;
    private final int positionBitsToShift;
    private final int initialTermId;
    private final UnsafeBuffer[] termBuffers;
    private ReadablePosition[] subscriberPositions = EMPTY_POSITIONS;
    private final RawLog rawLog;
    private final Position publisherLimit;
    private long consumerPosition = 0L;
    private long cleanPosition = 0L;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;

    public DirectPublication(long correlationId, int sessionId, int streamId, Position publisherLimit, RawLog rawLog) {
        this.correlationId = correlationId;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.termBuffers = rawLog.termBuffers();
        this.initialTermId = LogBufferDescriptor.initialTermId((UnsafeBuffer)rawLog.metaData());
        int termLength = rawLog.termLength();
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.termWindowLength = Configuration.ipcPublicationTermWindowLength(termLength);
        this.tripGain = this.termWindowLength / 8;
        this.publisherLimit = publisherLimit;
        this.rawLog = rawLog;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public RawLog rawLog() {
        return this.rawLog;
    }

    public int publisherLimitId() {
        return this.publisherLimit.id();
    }

    public void close() {
        this.publisherLimit.close();
        for (ReadablePosition position : this.subscriberPositions) {
            position.close();
        }
        this.rawLog.close();
    }

    public void addSubscription(ReadablePosition subscriberPosition) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)subscriberPosition);
    }

    public void removeSubscription(ReadablePosition subscriberPosition) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)subscriberPosition);
        subscriberPosition.close();
    }

    int updatePublishersLimit(long nowInMillis) {
        int workCount = 0;
        long minSubscriberPosition = Long.MAX_VALUE;
        long maxSubscriberPosition = 0L;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            long position = subscriberPosition.getVolatile();
            minSubscriberPosition = Math.min(minSubscriberPosition, position);
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        if (0 != this.subscriberPositions.length) {
            LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)this.rawLog.metaData(), (long)nowInMillis);
            long proposedLimit = minSubscriberPosition + (long)this.termWindowLength;
            if (proposedLimit > this.tripLimit) {
                this.publisherLimit.setOrdered(proposedLimit);
                this.tripLimit = proposedLimit + this.tripGain;
                this.cleanBuffer(minSubscriberPosition);
                workCount = 1;
            }
        }
        this.consumerPosition = maxSubscriberPosition;
        return workCount;
    }

    private void cleanBuffer(long minConsumerPosition) {
        int termOffset;
        long cleanPosition = this.cleanPosition;
        int bytesForCleaning = (int)(minConsumerPosition - cleanPosition);
        UnsafeBuffer dirtyTerm = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
        int bufferCapacity = dirtyTerm.capacity();
        int length = Math.min(bytesForCleaning, bufferCapacity - (termOffset = (int)cleanPosition & bufferCapacity - 1));
        if (length > 0) {
            dirtyTerm.setMemory(termOffset, length, (byte)0);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    public long joiningPosition() {
        long maxSubscriberPosition = this.producerPosition();
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            maxSubscriberPosition = Math.max(maxSubscriberPosition, subscriberPosition.getVolatile());
        }
        return maxSubscriberPosition;
    }

    @Override
    public long producerPosition() {
        long rawTail = LogBufferDescriptor.rawTailVolatile((UnsafeBuffer)this.rawLog.metaData());
        int termOffset = LogBufferDescriptor.termOffset((long)rawTail, (long)this.rawLog.termLength());
        return LogBufferDescriptor.computePosition((int)LogBufferDescriptor.termId((long)rawTail), (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
    }

    @Override
    public void onTimeEvent(long time, DriverConductor conductor) {
        if (0 == this.refCount) {
            this.reachedEndOfLife = true;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
        throw new UnsupportedOperationException("not used");
    }

    public long timeOfLastStateChange() {
        throw new UnsupportedOperationException("not used");
    }

    public void delete() {
        this.close();
    }

    @Override
    public int incRef() {
        return ++this.refCount;
    }

    @Override
    public int decRef() {
        return --this.refCount;
    }

    @Override
    public long consumerPosition() {
        return this.consumerPosition;
    }

    @Override
    public boolean unblockAtConsumerPosition() {
        return LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.rawLog.metaData(), (long)this.consumerPosition);
    }
}

