/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import com.xebialabs.deployit.task.archive.TaskCallback;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DeploymentTrendsPercentileWidget
extends DashboardWidgetBase {
    private static final int EIGHTIETH_PERCENTILE = 80;

    public DeploymentTrendsPercentileWidget(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime begin, DateTime end) {
        Map<String, List<TaskState>> groupedTasks = this.groupSuccesfulTasksByMonth(begin, end);
        Map<String, Long> monthPercentileMap = DeploymentTrendsPercentileWidget.calculatePercentiles(groupedTasks);
        return DeploymentTrendsPercentileWidget.generateReportData(monthPercentileMap);
    }

    private Map<String, List<TaskState>> groupSuccesfulTasksByMonth(DateTime begin, DateTime end) {
        ArchivedTaskSearchParameters params = this.getSearchParameters().createdBetween(begin, end).thatCompleted().thatAreOfType(EnumSet.of(TaskType.INITIAL, TaskType.UNDEPLOY, TaskType.UPGRADE));
        final Map<String, List<TaskState>> groupedTasks = this.initializeMap(begin, end, new Function<String, List<TaskState>>(){

            public List<TaskState> apply(String input) {
                return Lists.newArrayList();
            }
        });
        this.taskArchive.searchTaskWithOnlyMetadata(params, new TaskCallback(){

            public void doWithTask(ArchivedTask task) {
                String month = DeploymentTrendsPercentileWidget.this.monthFormat.print((ReadableInstant)task.getCompletionDate());
                List dataPerMonth = (List)groupedTasks.get(month);
                if (dataPerMonth != null) {
                    dataPerMonth.add(task);
                }
            }
        });
        return groupedTasks;
    }

    private static Map<String, Long> calculatePercentiles(Map<String, List<TaskState>> groupedTasks) {
        return Maps.transformValues(groupedTasks, (Function)new Function<List<TaskState>, Long>(){

            public Long apply(List<TaskState> input) {
                return DeploymentTrendsPercentileWidget.getPercentile(input, 80);
            }
        });
    }

    private static long getPercentile(List<TaskState> tasks, int percentileRatio) {
        if (tasks.size() == 0) {
            return 0L;
        }
        Collections.sort(tasks, new Comparator<TaskState>(){

            @Override
            public int compare(TaskState o1, TaskState o2) {
                return (int)(ReportUtils.duration(o1) - ReportUtils.duration(o2));
            }
        });
        int indexOfPercentile = Long.valueOf(Math.round((double)percentileRatio * (double)tasks.size() / 100.0 + 0.5)).intValue();
        if (indexOfPercentile > 0) {
            --indexOfPercentile;
        }
        TaskState task = tasks.get(indexOfPercentile);
        return ReportUtils.duration(task);
    }

    private static Report generateReportData(Map<String, Long> monthPercentileMap) {
        Report report = new Report();
        ReportTimeScale timeScale = DeploymentTrendsPercentileWidget.findTimeScale(monthPercentileMap);
        block4: for (String month : monthPercentileMap.keySet()) {
            Report.ReportLine line = report.addLine();
            line.addValue("month", (Object)month);
            line.addValue("timeScale", (Object)timeScale.toString());
            switch (timeScale) {
                case SECS: {
                    line.addValue("deploymentTime", (Object)DeploymentTrendsPercentileWidget.formatToSecs(monthPercentileMap.get(month)));
                    continue block4;
                }
                case MINS: {
                    line.addValue("deploymentTime", (Object)DeploymentTrendsPercentileWidget.formatToMins(monthPercentileMap.get(month)));
                    continue block4;
                }
            }
            line.addValue("deploymentTime", (Object)DeploymentTrendsPercentileWidget.formatToHours(monthPercentileMap.get(month)));
        }
        return report;
    }

    private static ReportTimeScale findTimeScale(Map<String, Long> monthPercentileMap) {
        Long maxDeploymentTime = Collections.max(monthPercentileMap.values());
        if (TimeUnit.MILLISECONDS.toSeconds(maxDeploymentTime) < 600L) {
            return ReportTimeScale.SECS;
        }
        if (TimeUnit.MILLISECONDS.toMinutes(maxDeploymentTime) < 600L) {
            return ReportTimeScale.MINS;
        }
        return ReportTimeScale.HRS;
    }

    private static enum ReportTimeScale {
        SECS,
        MINS,
        HRS;

    }
}

