/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.core.rest.api.DeploymentObjectGenerator;
import com.xebialabs.deployit.core.rest.api.DeploymentUtils;
import com.xebialabs.deployit.core.rest.api.DeploymentWriter;
import com.xebialabs.deployit.core.rest.api.InvalidDeploymentException;
import com.xebialabs.deployit.core.rest.api.PermissionChecker;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.deployment.ChangeSetBuilder;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.PreviewStepAdapter;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.dependency.DependencyService;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.RollbackService;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xlplatform.utils.Implicits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.ws.rs.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.collection.immutable.List;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.DeploymentService {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private DeployedService deployedService;
    @Autowired
    private RollbackService rollbackService;
    @Autowired
    private DependencyService dependencyService;
    @Autowired
    private TaskExecutionEngine engine;
    @Autowired
    private Validator validator;
    @Autowired
    private WorkDirFactory workDirFactory;
    @Autowired
    private PermissionChecker permissionChecker;
    @Autowired
    private DeploymentObjectGenerator deploymentObjectGenerator;
    private Cache<String, PreviewWithWorkdir<?>> previewCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new PreviewCleaner()).build();
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    @PreDestroy
    private void cleanCache() {
        this.previewCache.invalidateAll();
        this.previewCache.cleanUp();
    }

    public boolean isDeployed(String applicationId, String environmentId) {
        logger.trace("isDeployed {}, {}", (Object)applicationId, (Object)environmentId);
        Checks.checkNotNull((Object)applicationId, (String)"application");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        Application application = DeploymentUtils.castAndCheck(this.repositoryService.read(applicationId), Application.class);
        Environment environment = DeploymentUtils.castAndCheck(this.repositoryService.read(environmentId), Environment.class);
        return this.repositoryService.exists(IdGenerator.generateId((String)environment.getId(), (String)application.getId()));
    }

    public Deployment prepareInitial(String versionId, String environmentId) {
        this.previewCache.cleanUp();
        logger.trace("prepareInitial {}, {}", (Object)versionId, (Object)environmentId);
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        Version version = DeploymentUtils.castAndCheck(this.repositoryService.read(versionId), Version.class);
        Environment env = DeploymentUtils.castAndCheck(this.repositoryService.read(environmentId), Environment.class);
        this.permissionChecker.checkPermission(DeployitPermissions.DEPLOY_INITIAL, env);
        return this.deploymentObjectGenerator.forInitial(version, env);
    }

    public Deployment prepareUpdate(String newVersionId, String deployedApplicationId) {
        this.previewCache.cleanUp();
        logger.trace("prepareUpgrade {}, {}", (Object)newVersionId, (Object)deployedApplicationId);
        Checks.checkNotNull((Object)newVersionId, (String)"version");
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        DeployedApplication deployedApplication = DeploymentUtils.castAndCheck(this.repositoryService.read(deployedApplicationId), DeployedApplication.class);
        Environment env = deployedApplication.getEnvironment();
        this.permissionChecker.checkPermission(DeployitPermissions.DEPLOY_UPGRADE, env);
        Version newVersion = DeploymentUtils.castAndCheck(this.repositoryService.read(newVersionId), Version.class);
        return this.deploymentObjectGenerator.forUpdate(deployedApplication, newVersion, env);
    }

    public Deployment prepareUndeploy(String deployedApplicationId) {
        this.previewCache.cleanUp();
        logger.trace("prepareUndeployApplication {}", (Object)deployedApplicationId);
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        DeployedApplication deployedApplication = DeploymentUtils.castAndCheck(this.repositoryService.read(deployedApplicationId), DeployedApplication.class);
        this.checkPermission(DeployitPermissions.UNDEPLOY, deployedApplication.getEnvironment().getId());
        Deployment unDeployment = DeploymentWriter.createDeployment(deployedApplication, Deployment.DeploymentType.UNDEPLOYMENT);
        this.applyUnDeployementGroups(deployedApplication, unDeployment);
        return unDeployment;
    }

    private void applyUnDeployementGroups(DeployedApplication deployedApplication, Deployment unDeployment) {
        if (ServerConfiguration.getInstance().isServerResolveApplicationDependencies()) {
            java.util.List dependenciesToDelete = Implicits.listOfListToJavaListOfList((List)this.dependencyService.findDependencyGroupsToDeleteAndValidate(deployedApplication));
            java.util.List unDeploymentGroups = dependenciesToDelete.stream().map(group -> group.stream().map(app -> DeploymentWriter.createDeployment(app, Deployment.DeploymentType.UNDEPLOYMENT)).collect(Collectors.toList())).collect(Collectors.toList());
            unDeployment.setGroupedRequiredDeployments(unDeploymentGroups);
        }
    }

    public Deployment prepareAutoDeployeds(Deployment deployment) {
        this.previewCache.cleanUp();
        logger.trace("updateDeployeds {}", (Object)deployment);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        this.deployedService.scanMissingPlaceholders(deployedApplication, environment);
        java.util.List additionalDeployeds = this.deployedService.createDeployedsForNonExistingCombinations(deployedApplication, version, environment, DeploymentResource.getDeployeds(deployment), new HashMap());
        this.permissionChecker.checkPermission(deployment, deployment.getGroupedRequiredDeployments());
        java.util.List updatedRequiredDeployments = deployment.getGroupedRequiredDeployments().stream().map(s -> s.stream().map(this::prepareAutoDeployeds).collect(Collectors.toList())).collect(Collectors.toList());
        deployment.setGroupedRequiredDeployments(updatedRequiredDeployments);
        deployment.getDeployeds().clear();
        deployment.addAll(DeploymentWriter.convertDeployeds(additionalDeployeds));
        return deployment;
    }

    private DeployedApplication preGenerateCheck(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.invalidatePreview(deployment);
        return (DeployedApplication)deployment.getDeployedApplication();
    }

    private void invalidatePreview(Deployment deployment) {
        this.previewCache.cleanUp();
        if (deployment.getId() != null) {
            this.previewCache.invalidate((Object)deployment.getId());
        }
    }

    public Deployment generateSelectedDeployeds(java.util.List<String> deployableIds, Deployment deployment) {
        return this.generateSelectedDeployeds(new SelectedDeployment(deployableIds, deployment));
    }

    public Deployment generateSelectedDeployeds(SelectedDeployment selectedDeployment) {
        this.previewCache.cleanUp();
        java.util.List deployableIds = selectedDeployment.getSelectedDeployableIds();
        Checks.checkArgument((deployableIds.size() > 0 ? 1 : 0) != 0, (String)"Should select at least one deployable to generate a deployed", (Object[])new Object[0]);
        Deployment deployment = selectedDeployment.getDeployment();
        logger.trace("generateSelectedDeployeds {}, {}", (Object)deployableIds, (Object)deployment);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        logger.debug("Generating deployeds from package [{}]", (Object)version);
        Set allDeployables = deployment.getRequiredDeployments().stream().map(this::preGenerateCheck).map(DeployedApplication::getVersion).flatMap(dependencyVersion -> dependencyVersion.getDeployables().stream()).collect(Collectors.toCollection(() -> new HashSet(version.getDeployables())));
        ImmutableMap deployables = Maps.uniqueIndex((Iterable)allDeployables, ConfigurationItem::getId);
        java.util.List deployableCIs = deployableIds.stream().peek(arg_0 -> DeploymentResource.lambda$generateSelectedDeployeds$17((Map)deployables, arg_0)).map(((Map)deployables)::get).collect(Collectors.toList());
        Environment environment = deployedApplication.getEnvironment();
        this.deployedService.scanMissingPlaceholders(deployedApplication, environment);
        GeneratedDeployeds selectedDeployeds = this.deployedService.generateSelectedDeployeds(deployedApplication, deployableCIs, version, environment);
        deployment.addAll(DeploymentWriter.convertDeployeds(selectedDeployeds.getDeployeds()));
        return deployment;
    }

    public Deployment generateSingleDeployed(String deployableId, String containerId, Type deployedType, Deployment deployment) {
        this.previewCache.cleanUp();
        logger.debug("Creating explicit deployed for [{}] and [{}]", (Object)deployableId, (Object)containerId);
        DeployedApplication deployedApplication = this.preGenerateCheck(deployment);
        Version version = deployedApplication.getVersion();
        Environment environment = deployedApplication.getEnvironment();
        Checks.checkNotNull((Object)deployableId, (String)"deployable");
        Checks.checkNotNull((Object)containerId, (String)"container");
        Deployable deployable = DeploymentUtils.castAndCheck((ConfigurationItem)Iterables.find(this.collectDeployables(deployment), input -> input.getId().equals(deployableId)), Deployable.class);
        Container container = DeploymentUtils.castAndCheck((ConfigurationItem)Iterables.find((Iterable)environment.getMembers(), input -> input.getId().equals(containerId)), Container.class);
        GeneratedDeployeds selectedDeployed = this.deployedService.createSelectedDeployed(deployedApplication, deployable, container, deployedType, version, environment);
        deployment.addAll(DeploymentWriter.convertDeployeds(selectedDeployed.getDeployeds()));
        return deployment;
    }

    private java.util.List<Deployable> collectDeployables(Deployment deployment) {
        Stream dependantDeployables = deployment.getRequiredDeployments().stream().flatMap(depl -> ((DeployedApplication)depl.getDeployedApplication()).getVersion().getDeployables().stream());
        return Stream.concat(((DeployedApplication)deployment.getDeployedApplication()).getVersion().getDeployables().stream(), dependantDeployables).collect(Collectors.toList());
    }

    public Deployment validate(Deployment deployment) {
        this.previewCache.cleanUp();
        this.invalidatePreview(deployment);
        if (!this.validateDeploymentWithValidator(deployment)) {
            throw new InvalidDeploymentException(deployment);
        }
        return deployment;
    }

    @Workdir(prefix="preview")
    public TaskPreviewBlock taskPreviewBlock(Deployment deployment) {
        return (TaskPreviewBlock)WorkDirTemplate.cleanOnException(workDir -> {
            this.checkDeploymentInput(deployment);
            try {
                this.invalidatePreview(deployment);
                PreviewWithWorkdir<TaskPreviewBlock> preview = this.getTaskPreview(deployment, workDir, new TaskPreviewBlockBuilder());
                return preview.getPreview();
            }
            catch (Exception e) {
                throw new DeployitException((Throwable)e, "Error getting task preview for deployment [%s]", new Object[]{deployment.getId()});
            }
        });
    }

    @Workdir(prefix="preview")
    public StepState taskPreviewBlock(Deployment deployment, String blockId, int stepNr) {
        return (StepState)WorkDirTemplate.cleanOnException(workDir -> {
            this.checkDeploymentInput(deployment);
            try {
                PreviewWithWorkdir<TaskPreviewBlock> preview = this.getTaskPreview(deployment, workDir, new TaskPreviewBlockBuilder());
                Block topBlock = (Block)preview.getPreview().getBlock();
                BlockState child = (BlockState)topBlock.getBlock(BlockPath.apply((String)blockId).tail()).getOrElse(null);
                if (!(child instanceof StepBlock)) {
                    throw new DeployitException("Block [%s] is a composite block so it has no steps", new Object[]{blockId});
                }
                java.util.List steps = ((StepBlock)child).getSteps();
                Checks.checkArgument((stepNr > 0 && stepNr <= steps.size() ? 1 : 0) != 0, (String)"Not a valid step number [%s]", (Object[])new Object[]{stepNr});
                StepState stepState = (StepState)steps.get(stepNr - 1);
                if (this.hasPermission(DeployitPermissions.TASK_PREVIEWSTEP)) {
                    return new PreviewStepAdapter((TaskStep)stepState);
                }
                return stepState;
            }
            catch (Exception e) {
                throw new DeployitException((Throwable)e, "Error getting task preview for deployment [%s]", new Object[]{deployment.getId()});
            }
        });
    }

    private <T extends AbstractDto> PreviewWithWorkdir<T> getTaskPreview(Deployment deployment, WorkDir workDir, PreviewBuilder<T> builder) throws ExecutionException {
        String id = deployment.getId();
        Checks.checkArgument((id != null ? 1 : 0) != 0, (String)"Old-style client detected, deployment does not have an 'id' set. Please upgrade your client.", (Object[])new Object[0]);
        Callable<PreviewWithWorkdir> preview = () -> {
            logger.info("Generating {} for deployment [{}]", (Object)builder, (Object)deployment.getId());
            ConfigurationItem configurationItem = this.validateDeployedApplication(deployment.getDeployedApplication());
            if (!configurationItem.get$validationMessages().isEmpty()) {
                throw new InvalidDeploymentException("The DeployedApplication contained validation errors, not generating a steps view.");
            }
            this.filterDeployedsWithValidationErrors(deployment);
            TaskSpecification taskSpecification = this.createDeploymentTask(deployment, true);
            logger.info("Done generating {} for deployment [{}]", (Object)builder, (Object)deployment.getId());
            return builder.build(deployment.getId(), workDir, taskSpecification);
        };
        PreviewWithWorkdir possiblyCached = (PreviewWithWorkdir)this.previewCache.get((Object)id, preview);
        if (!possiblyCached.workDir.getPath().equals(workDir.getPath())) {
            workDir.delete();
        }
        return possiblyCached;
    }

    private void filterDeployedsWithValidationErrors(Deployment deployment) {
        for (ConfigurationItem configurationItem : Lists.newArrayList((Iterable)deployment.getDeployeds())) {
            if (this.validator.validate(configurationItem, new ConfigurationItem[0]).size() <= 0) continue;
            logger.debug("ConfigurationItem [{} ({})] contained validation errors, not taking it into account for steps view.", (Object)configurationItem.getId(), (Object)configurationItem.getType());
            deployment.getDeployeds().remove(configurationItem);
        }
    }

    @Workdir(prefix="task")
    public String createTask(Deployment deployment) {
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            this.checkDeploymentInput(deployment);
            if (!this.validateDeploymentWithValidator(deployment)) {
                throw new InvalidDeploymentException("The deployment has validation errors.");
            }
            this.invalidatePreview(deployment);
            logger.trace("Creating task for {}", (Object)deployment);
            this.warnAboutUsingDeprecatedCI(deployment);
            TaskSpecification deploymentTask = this.createDeploymentTask(deployment, false);
            String taskId = this.engine.register(deploymentTask);
            logger.debug("Registered {} task {} for Deployed Application {}", new Object[]{deployment.getDeploymentType(), taskId, deployment.getDeployedApplication().getId()});
            EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, deployment.getDeploymentType().toString(), deployment.getDeployedApplication().getId()));
            return taskId;
        });
    }

    private void warnAboutUsingDeprecatedCI(Deployment deployment) {
        DeployedApplication da = (DeployedApplication)deployment.getDeployedApplication();
        if (Type.valueOf(CompositePackage.class).equals((Object)da.getVersion().getType())) {
            Deprecations.deprecated((String)"Deprecation warning: You are deploying a udm.CompositePackage [{}]. Please use application dependencies instead. Refer to the upgrade manual for more information.", (Object[])new Object[]{da.getVersion().getId()});
        }
    }

    private void checkDeploymentInput(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.permissionChecker.checkPermission(deployment, deployment.getGroupedRequiredDeployments());
        this.checkDeployedDuplicates(deployment);
    }

    public String rollback(@PathParam(value="taskid") String taskid) {
        Task retrieve = this.engine.retrieve(taskid);
        TaskSpecification rollback = this.rollbackService.rollback(retrieve);
        return this.engine.register(rollback);
    }

    public Map<String, String> effectiveDictionary(String environment, String application, String container) {
        Checks.checkNotNull((Object)environment, (String)"environment");
        Environment readEnv = DeploymentUtils.castAndCheck(this.repositoryService.read(environment), Environment.class);
        java.util.List dictionaries = readEnv.getDictionaries();
        Dictionaries dicts = Dictionaries.of((java.util.List)dictionaries);
        if (application != null) {
            Application appCi = DeploymentUtils.castAndCheck(this.repositoryService.read(application), Application.class);
            dicts = dicts.filterBy(appCi);
        }
        if (container != null) {
            Container containerCi = DeploymentUtils.castAndCheck(this.repositoryService.read(container), Container.class);
            dicts = dicts.filterBy(containerCi);
        }
        return Maps.newHashMap((Map)Maps.transformValues((Map)((MapStringStringView)dicts.consolidate().getEntries()).getWrapped(), StringValue::toPublicFacingValue));
    }

    private void checkDeployedDuplicates(Deployment deployment) {
        FluentIterable deployeds = FluentIterable.from((Iterable)deployment.getRequiredDeployments()).transformAndConcat(input -> input.getDeployeds()).append((Iterable)deployment.getDeployeds());
        HashSet<String> processed = new HashSet<String>();
        for (ConfigurationItem deployed : deployeds) {
            if (!processed.contains(deployed.getId())) {
                processed.add(deployed.getId());
                continue;
            }
            throw new InvalidDeploymentException("You are trying to deploy multiple items with the same id: " + deployed.getId() + " on the same container.");
        }
    }

    private TaskSpecification createDeploymentTask(Deployment deployment, boolean previewMode) {
        switch (deployment.getDeploymentType()) {
            case INITIAL: 
            case UPDATE: {
                return this.createTask(deployment, previewMode);
            }
            case UNDEPLOYMENT: {
                return this.createUndeploymentTask(deployment, previewMode);
            }
        }
        throw new IllegalArgumentException("Unknown deployment type: " + deployment.getDeploymentType());
    }

    private TaskSpecification createTask(Deployment deployment, boolean previewMode) {
        WorkDir workDirForExistingDeployment = this.workDirFactory.newWorkDir("previous");
        logger.trace("Got workdir [{}] for reading existing deployment", (Object)workDirForExistingDeployment);
        try {
            MultiDeltaSpecification deltaSpecification = this.createDeltaSpecification(deployment, this.readExistingDeployedApplication(deployment, WorkdirHolder.get()));
            if (!previewMode) {
                this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecificationWithDependencies)deltaSpecification));
            }
            TaskSpecification taskSpecification = this.deploymentService.getTaskFullSpecification(deltaSpecification, WorkdirHolder.get(), new WorkDir[]{workDirForExistingDeployment});
            return taskSpecification;
        }
        catch (RuntimeException e) {
            workDirForExistingDeployment.delete();
            WorkdirHolder.get().delete();
            throw e;
        }
        finally {
            if (previewMode) {
                workDirForExistingDeployment.delete();
            }
        }
    }

    private MultiDeltaSpecification createDeltaSpecification(Deployment deployment, Map<String, DeployedApplication> existingDeployedApplications) {
        switch (deployment.getDeploymentType()) {
            case INITIAL: {
                return this.deploymentService.prepareInitialSpecification(deployment, existingDeployedApplications);
            }
            case UPDATE: {
                return this.deploymentService.prepareUpgradeSpecification(deployment, existingDeployedApplications);
            }
        }
        throw new IllegalArgumentException("Deployment " + deployment.getId() + " has invalid type " + deployment.getDeploymentType());
    }

    private Map<String, DeployedApplication> readExistingDeployedApplication(Deployment deployment, WorkDir workDir) {
        return Maps.uniqueIndex((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.concat(Collections.singleton(deployment), (Iterable)deployment.getRequiredDeployments()), input -> input.isOfType(Deployment.DeploymentType.UPDATE)), input -> (DeployedApplication)this.repositoryService.read(input.getDeployedApplication().getId(), workDir)), BaseConfigurationItem::getId);
    }

    private TaskSpecification createUndeploymentTask(Deployment deployment, boolean previewMode) {
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        this.checkPermission(DeployitPermissions.UNDEPLOY, deployedApplication.getEnvironment().getId());
        if (deployedApplication.isUndeployDependencies() && deployment.getGroupedRequiredDeployments().isEmpty()) {
            this.applyUnDeployementGroups(deployedApplication, deployment);
        }
        MultiDeltaSpecification deltaSpecification = this.deploymentService.prepareUndeploymentWithDependencies(deployment);
        if (!previewMode) {
            this.repositoryService.checkReferentialIntegrity(ChangeSetBuilder.determineChanges((DeltaSpecificationWithDependencies)this.deploymentService.prepareUndeploymentWithDependencies(deployment)));
        }
        return this.deploymentService.getTaskFullSpecification(deltaSpecification, WorkdirHolder.get(), new WorkDir[0]);
    }

    private static Set<Deployed> getDeployeds(Deployment deployment) {
        java.util.List deployedEntities = deployment.getDeployeds();
        FluentIterable from = FluentIterable.from((Iterable)deployedEntities);
        Checks.checkArgument((boolean)from.allMatch(Predicates.or((Predicate)Predicates.instanceOf(Deployed.class), (Predicate)Predicates.instanceOf(EmbeddedDeployed.class))), (String)"The Deployment can only contain Deployed or EmbeddedDeployed configuration items", (Object[])new Object[0]);
        return Sets.newHashSet((Iterable)from.filter(Deployed.class));
    }

    private boolean validateDeploymentWithValidator(Deployment deployment) {
        ConfigurationItem deployedApplication = this.validateDeployedApplication(deployment.getDeployedApplication());
        deployment.setDeployedApplication(deployedApplication);
        boolean deployedApplicationValid = deployedApplication.get$validationMessages().isEmpty();
        boolean deployedsValid = true;
        try {
            ArrayList cis = Lists.newArrayList((Iterable)deployment.getDeployeds());
            for (Deployment d : deployment.getRequiredDeployments()) {
                cis.addAll(d.getDeployeds());
            }
            this.validator.validateCis((java.util.List)cis);
        }
        catch (Validator.ValidationsFailedException ignored) {
            deployedsValid = false;
        }
        deployedsValid = deployedsValid && this.updateWithValidatedDeployeds(deployment);
        for (Deployment depl : deployment.getRequiredDeployments()) {
            deployedsValid = deployedsValid && this.updateWithValidatedDeployeds(depl);
        }
        return deployedsValid && deployedApplicationValid;
    }

    private boolean updateWithValidatedDeployeds(Deployment deployment) {
        ArrayList validatedDeployeds = Lists.newArrayList();
        boolean deployedsValid = this.validateDeployeds(deployment.getDeployeds(), validatedDeployeds);
        deployment.setDeployeds((java.util.List)validatedDeployeds);
        return deployedsValid;
    }

    private boolean validateDeployeds(java.util.List<ConfigurationItem> deployeds, java.util.List<ConfigurationItem> validated) {
        boolean deployedsValid = true;
        HashSet ids = Sets.newHashSet();
        for (ConfigurationItem configurationItem : deployeds) {
            if (!ids.add(configurationItem.getId())) {
                ValidationMessage msg = new ValidationMessage(configurationItem.getId(), "name", String.format("The deployed [%s] must have a unique name within the container [%s]", configurationItem, ((EmbeddedDeployedContainer)configurationItem).getContainer()));
                configurationItem.get$validationMessages().add(msg);
                validated.add(configurationItem);
                deployedsValid = false;
                continue;
            }
            validated.add(configurationItem);
        }
        return deployedsValid;
    }

    private ConfigurationItem validateDeployedApplication(ConfigurationItem deployedApplicationEntity) {
        java.util.List messages = this.validator.validate(deployedApplicationEntity, Collections.EMPTY_LIST);
        Iterable filteredMessages = Iterables.filter((Iterable)messages, input -> !"deployeds".equals(input.getPropertyName()));
        if (Iterables.size((Iterable)filteredMessages) > 0) {
            deployedApplicationEntity.get$validationMessages().addAll(Lists.newArrayList((Iterable)filteredMessages));
        }
        return deployedApplicationEntity;
    }

    private static /* synthetic */ void lambda$generateSelectedDeployeds$17(Map deployables, String id) {
        Checks.checkArgument((boolean)deployables.containsKey(id), (String)"All sources should be from same package or its dependencies.", (Object[])new Object[0]);
    }

    private static final class TaskPreviewBlockBuilder
    implements PreviewBuilder<TaskPreviewBlock> {
        private TaskPreviewBlockBuilder() {
        }

        @Override
        public PreviewWithWorkdir<TaskPreviewBlock> build(String deploymentId, WorkDir workDir, TaskSpecification taskSpecification) {
            TaskPreviewBlock preview = new TaskPreviewBlock(deploymentId, (BlockState)taskSpecification.getBlock());
            return new PreviewWithWorkdir<TaskPreviewBlock>((AbstractDto)preview, workDir, null);
        }

        public String toString() {
            return "task preview block";
        }
    }

    private static interface PreviewBuilder<T extends AbstractDto> {
        public PreviewWithWorkdir<T> build(String var1, WorkDir var2, TaskSpecification var3);
    }

    private static class PreviewCleaner
    implements RemovalListener<String, PreviewWithWorkdir<?>> {
        private PreviewCleaner() {
        }

        public void onRemoval(RemovalNotification<String, PreviewWithWorkdir<?>> notification) {
            if (notification.getValue() != null) {
                logger.info("Cleaning up Preview [{}] with workDir [{}]", notification.getKey(), (Object)((PreviewWithWorkdir)notification.getValue()).workDir);
                ((PreviewWithWorkdir)notification.getValue()).cleanUp();
            }
        }
    }

    private static class PreviewWithWorkdir<T extends AbstractDto> {
        private T preview;
        private WorkDir workDir;

        private PreviewWithWorkdir(T preview, WorkDir workDir) {
            this.preview = preview;
            this.workDir = workDir;
        }

        void cleanUp() {
            this.workDir.delete();
        }

        public T getPreview() {
            return this.preview;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.workDir.delete();
        }

        /* synthetic */ PreviewWithWorkdir(AbstractDto x0, WorkDir x1, 1 x2) {
            this(x0, x1);
        }
    }
}

