/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.TaskResource;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.spi.event.TaskAbortedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskArchivedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskAssignedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskCancelledEvent;
import com.xebialabs.deployit.engine.spi.event.TaskScheduledEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStartedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStoppedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Controller
public abstract class AbstractTaskResource
extends AbstractSecuredResource {
    protected static final Logger logger = LoggerFactory.getLogger(TaskResource.class);
    @Autowired
    protected IEngine engine;
    @Autowired
    protected JcrTaskArchive taskArchive;
    private Config systemConf = ConfigFactory.parseResources((String)"system.conf").withFallback((ConfigMergeable)ConfigFactory.defaultReference());

    public void start(String taskId) {
        this.checkOwnership(taskId);
        this.engine.execute(taskId);
        EventBusHolder.publish((Object)new TaskStartedEvent(taskId));
    }

    public void schedule(String taskId, DateTime time) {
        this.checkOwnership(taskId);
        Checks.checkNotNull((Object)time, (String)"No time specified for scheduling");
        DateTime utcTime = time.withZone(DateTimeZone.UTC);
        EventBusHolder.publish((Object)new TaskScheduledEvent(taskId, utcTime));
        this.engine.schedule(taskId, utcTime);
    }

    public void cancel(String taskId) {
        this.checkOwnership(taskId);
        this.engine.cancel(taskId);
        EventBusHolder.publish((Object)new TaskCancelledEvent(taskId));
    }

    public void archive(String taskId) {
        this.checkOwnership(taskId);
        this.engine.archive(taskId);
        EventBusHolder.publish((Object)new TaskArchivedEvent(taskId));
    }

    public void stop(String taskId) {
        this.checkOwnership(taskId);
        try {
            this.engine.stop(taskId);
            EventBusHolder.publish((Object)new TaskStoppedEvent(taskId));
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not stop task %s", taskId), (Throwable)ise);
            throw ise;
        }
    }

    public void abort(String taskId) {
        this.checkOwnership(taskId);
        try {
            this.engine.abort(taskId);
            EventBusHolder.publish((Object)new TaskAbortedEvent(taskId));
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not abort task %s", taskId), (Throwable)ise);
            throw ise;
        }
    }

    public Collection<ArchivedTask> search(ArchivedTaskSearchParameters parameters, boolean loadSteps) {
        if (!this.hasPermission(PlatformPermissions.ADMIN) && !this.hasPermission(DeployitPermissions.REPORT_VIEW)) {
            throw PermissionDeniedException.withMessage((String)"Only user with report#view permission or ADMIN can search the task archive.");
        }
        if (loadSteps) {
            return this.taskArchive.searchTasks(parameters);
        }
        return this.taskArchive.searchTasksWithoutLoadingSteps(parameters);
    }

    public void purge(String taskId) {
        if (!this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only user with ADMIN role can purge the task archive.");
        }
        this.taskArchive.purgeTask(taskId);
    }

    protected Task doAssign(String taskId, String owner) {
        Task task = this.engine.retrieve(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)owner, null);
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            task.setOwner((Authentication)token);
        } else if (this.hasPermission(DeployitPermissions.TASK_ASSIGN) && task.getOwner().equals(Permissions.getAuthenticatedUserName())) {
            task.setOwner((Authentication)token);
        } else {
            throw PermissionDeniedException.withMessage((String)"Neither ADMIN nor TASK_ASSIGN permissions are granted to you or you are not the owner of the task");
        }
        EventBusHolder.publish((Object)new TaskAssignedEvent(taskId, owner));
        return task;
    }

    protected Task doTakeover(String taskId, String owner) {
        String newOwner = Permissions.getAuthenticatedUserName();
        Task task = this.engine.retrieve(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        this.checkPermission(DeployitPermissions.TASK_TAKEOVER, task);
        if (!task.getOwner().equals(owner)) {
            throw PermissionDeniedException.withMessage((String)String.format("You have not specified the correct owner for task [%s], not taking over.", owner));
        }
        task.setOwner(Permissions.getAuthentication());
        EventBusHolder.publish((Object)new TaskAssignedEvent(taskId, newOwner));
        return task;
    }

    protected void checkPermission(Permission permission, Task task) {
        if (TaskMetadata.metadataContainsKey((TaskWithBlock)task, (String)"environment_id")) {
            String env = TaskMetadata.getMetadata((TaskWithBlock)task, (String)"environment_id");
            this.checkPermission(permission, env);
        } else {
            this.checkPermission(permission);
        }
    }

    protected boolean hasBeenModifiedSince(StepState step, DateTime ifModifiedSince) {
        if (ifModifiedSince == null) {
            return true;
        }
        DateTime lastModifiedCal = step.getCompletionDate();
        if (step instanceof TaskStep) {
            lastModifiedCal = ((TaskStep)step).getLastModificationDate();
        }
        return lastModifiedCal.withMillis(0L).isAfter((ReadableInstant)ifModifiedSince);
    }

    protected boolean isCalledByOwner(String taskId) {
        try {
            this.calledByOwner(this.liveOrArchivedTask(taskId, false));
            return true;
        }
        catch (PermissionDeniedException e) {
            return false;
        }
    }

    protected SerializableTask calledByOwner(SerializableTask t) {
        Task task;
        String currentUser = Permissions.getAuthenticatedUserName();
        if (!currentUser.equals(t.getOwner()) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can access the task.");
        }
        if (t instanceof Task && !(task = (Task)t).getAuthentication().isAuthenticated()) {
            task.setOwner(Permissions.getAuthentication());
        }
        return t;
    }

    protected SerializableTask liveOrArchivedTask(String taskId, boolean loadSteps) {
        Task t;
        try {
            t = this.engine.retrieve(taskId);
        }
        catch (TaskNotFoundException e) {
            t = this.taskArchive.getTask(taskId, loadSteps);
        }
        return this.calledByOwner((SerializableTask)t);
    }

    protected ArchivedTaskSearchParameters toSearchParameters(LocalDate begin, LocalDate end) {
        ArchivedTaskSearchParameters parameters = new ArchivedTaskSearchParameters();
        if (end == null) {
            end = new LocalDate();
        }
        if (begin != null) {
            parameters.createdBetween(begin.toDateTimeAtStartOfDay(), end.toDateTimeAtStartOfDay());
        }
        parameters.showPage(0, this.systemConf.getInt("xl.rest.api.maxPageSize"));
        return parameters;
    }

    private void checkOwnership(String taskId) {
        if (!this.isCalledByOwner(taskId) && !this.hasPermission(PlatformPermissions.ADMIN)) {
            throw PermissionDeniedException.withMessage((String)"Only owner or ADMIN can archive the task.");
        }
    }

    public void setTaskArchive(JcrTaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public void setEngine(IEngine engine) {
        this.engine = engine;
    }

    @HttpResponseCodeResult(statusCode=304)
    protected static class NotModifiedException
    extends DeployitException {
        protected NotModifiedException() {
        }
    }
}

