/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.agrona.generation.OutputManager;

public class StringWriterOutputManager
implements OutputManager {
    private String packageName;
    private final Map<String, StringWriter> sourceFileByName = new HashMap<String, StringWriter>();

    @Override
    public Writer createOutput(String name) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.sourceFileByName.put(this.packageName + "." + name, stringWriter);
        return stringWriter;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public CharSequence getSource(String name) {
        return this.sourceFileByName.get(name).toString();
    }

    public Map<String, CharSequence> getSources() {
        HashMap<String, CharSequence> sources = new HashMap<String, CharSequence>();
        for (Map.Entry<String, StringWriter> entry : this.sourceFileByName.entrySet()) {
            sources.put(entry.getKey(), entry.getValue().toString());
        }
        return sources;
    }

    public void clear() {
        this.packageName = "";
        this.sourceFileByName.clear();
    }
}

