/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.LocaleIDs;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class ICUResourceTableAccess {
    public static String getTableString(String path, ULocale locale2, String tableName, String itemName) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(path, locale2.getBaseName());
        return ICUResourceTableAccess.getTableString(bundle, tableName, null, itemName);
    }

    public static String getTableString(ICUResourceBundle bundle, String tableName, String subtableName, String item) {
        String result2 = null;
        try {
            while (true) {
                String fallbackLocale;
                ICUResourceBundle table;
                if ("currency".equals(subtableName)) {
                    table = bundle.getWithFallback("Currencies");
                    table = table.getWithFallback(item);
                    return table.getString(1);
                }
                table = bundle.findWithFallback(tableName);
                if (table == null) {
                    return item;
                }
                ICUResourceBundle stable = table;
                if (subtableName != null) {
                    stable = table.findWithFallback(subtableName);
                }
                if (stable != null && (result2 = stable.findStringWithFallback(item)) != null) break;
                if (subtableName == null) {
                    String currentName = null;
                    if (tableName.equals("Countries")) {
                        currentName = LocaleIDs.getCurrentCountryID(item);
                    } else if (tableName.equals("Languages")) {
                        currentName = LocaleIDs.getCurrentLanguageID(item);
                    }
                    if (currentName != null && (result2 = table.findStringWithFallback(currentName)) != null) break;
                }
                if ((fallbackLocale = table.findStringWithFallback("Fallback")) == null) {
                    return item;
                }
                if (fallbackLocale.length() == 0) {
                    fallbackLocale = "root";
                }
                if (fallbackLocale.equals(table.getULocale().getName())) {
                    return item;
                }
                bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(bundle.getBaseName(), fallbackLocale);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result2 != null && result2.length() > 0 ? result2 : item;
    }
}

