/*
 * Decompiled with CFR 0.152.
 */
package com.romix.akka.serialization.kryo;

import akka.serialization.Serializer;
import com.romix.akka.serialization.kryo.QueueBuilder;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u001b\tq1+\u001a:jC2L'0\u001a:Q_>d'BA\u0002\u0005\u0003\u0011Y'/_8\u000b\u0005\u00151\u0011!D:fe&\fG.\u001b>bi&|gN\u0003\u0002\b\u0011\u0005!\u0011m[6b\u0015\tI!\"A\u0003s_6L\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005a\u0011/^3vK\n+\u0018\u000e\u001c3feB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\r#V,W/\u001a\"vS2$WM\u001d\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005Ya.Z<J]N$\u0018M\\2f!\ryQdH\u0005\u0003=A\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\u0015\u0011#\"A\u0004\n\u0005\u0011\n#AC*fe&\fG.\u001b>fe\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"2\u0001K\u0015+!\t9\u0002\u0001C\u0003\u0016K\u0001\u0007a\u0003C\u0003\u001cK\u0001\u0007A\u0004C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\tA|w\u000e\\\u000b\u0002]A\u0019q\u0006N\u0010\u000e\u0003AR!!\r\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0005!!.\u0019<b\u0013\t)\u0004GA\u0003Rk\u0016,X\r\u0003\u00048\u0001\u0001\u0006IAL\u0001\u0006a>|G\u000e\t\u0005\u0006s\u0001!\tAO\u0001\u0006M\u0016$8\r\u001b\u000b\u0002?!)A\b\u0001C\u0001{\u00059!/\u001a7fCN,GC\u0001 B!\tyq(\u0003\u0002A!\t!QK\\5u\u0011\u0015\u00115\b1\u0001 \u0003\u0005y\u0007\"\u0002#\u0001\t\u0003)\u0015aA1eIR\u0011aH\u0012\u0005\u0006\u0005\u000e\u0003\ra\b")
public class SerializerPool {
    private final Function0<Serializer> newInstance;
    private final Queue<Serializer> pool;

    private Queue<Serializer> pool() {
        return this.pool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializer fetch() {
        Serializer serializer = this.pool().poll();
        if (serializer != null) return serializer;
        if (serializer != null) throw new MatchError((Object)serializer);
        return (Serializer)this.newInstance.apply();
    }

    public void release(Serializer o) {
        this.pool().offer(o);
    }

    public void add(Serializer o) {
        this.pool().add(o);
    }

    public SerializerPool(QueueBuilder queueBuilder, Function0<Serializer> newInstance) {
        this.newInstance = newInstance;
        this.pool = queueBuilder == null ? new ConcurrentLinkedQueue() : queueBuilder.build();
    }
}

