/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.remote.artery.CacheStatistics;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015cAB\u0001\u0003\u0003\u00031\u0001BA\bMeV\u0014u.\u001e8eK\u0012\u001c\u0015m\u00195f\u0015\t\u0019A!\u0001\u0004beR,'/\u001f\u0006\u0003\u000b\u0019\taA]3n_R,'\"A\u0004\u0002\t\u0005\\7.Y\u000b\u0004\u0013\tz3C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001B\u0001B\u0003%1#\u0001\u0005dCB\f7-\u001b;z\u0007\u0001\u0001\"a\u0003\u000b\n\u0005Ua!aA%oi\"Aq\u0003\u0001B\u0001B\u0003%1#A\tfm&\u001cG/Q4f)\"\u0014Xm\u001d5pY\u0012D\u0001\"\u0007\u0001\u0003\u0004\u0003\u0006YAG\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA\u000e\u001fA5\tAD\u0003\u0002\u001e\u0019\u00059!/\u001a4mK\u000e$\u0018BA\u0010\u001d\u0005!\u0019E.Y:t)\u0006<\u0007CA\u0011#\u0019\u0001!Qa\t\u0001C\u0002\u0011\u0012\u0011aS\t\u0003K!\u0002\"a\u0003\u0014\n\u0005\u001db!a\u0002(pi\"Lgn\u001a\t\u0003\u0017%J!A\u000b\u0007\u0003\u0007\u0005s\u0017\u0010\u0003\u0005-\u0001\t\r\t\u0015a\u0003.\u0003))g/\u001b3f]\u000e,GE\r\t\u00047yq\u0003CA\u00110\t\u0015\u0001\u0004A1\u00012\u0005\u00051\u0016CA\u0013\u000b\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q\u0019QGO\u001e\u0015\u0007YB\u0014\b\u0005\u00038\u0001\u0001rS\"\u0001\u0002\t\u000be\u0011\u00049\u0001\u000e\t\u000b1\u0012\u00049A\u0017\t\u000bE\u0011\u0004\u0019A\n\t\u000b]\u0011\u0004\u0019A\n\t\ru\u0002\u0001\u0015!\u0003\u0014\u0003\u0011i\u0015m]6\t\r}\u0002\u0001\u0015)\u0003\u0014\u0003\u0015)\u0007o\\2i\u0011\u0019\t\u0005\u0001)A\u0005\u0005\u0006!1.Z=t!\rY1\tI\u0005\u0003\t2\u0011Q!\u0011:sCfDaA\u0012\u0001!\u0002\u00139\u0015A\u0002<bYV,7\u000fE\u0002\f\u0007:Ba!\u0013\u0001!\u0002\u0013Q\u0015A\u00025bg\",7\u000fE\u0002\f\u0007NAa\u0001\u0014\u0001!\u0002\u0013Q\u0015AB3q_\u000eD7\u000fC\u0003O\u0001\u0011\u0015q*A\u0002hKR$\"\u0001U*\u0011\u0007-\tf&\u0003\u0002S\u0019\t1q\n\u001d;j_:DQ\u0001V'A\u0002\u0001\n\u0011a\u001b\u0005\u0006-\u0002!)aV\u0001\u0006gR\fGo]\u000b\u00021B\u0011q'W\u0005\u00035\n\u0011qbQ1dQ\u0016\u001cF/\u0019;jgRL7m\u001d\u0005\u00069\u0002!)!X\u0001\rO\u0016$xJ]\"p[B,H/\u001a\u000b\u0003]yCQ\u0001V.A\u0002\u0001BQ\u0001\u0019\u0001\u0005\n\u0005\f\u0001B]3n_Z,\u0017\t\u001e\u000b\u0003E\u0016\u0004\"aC2\n\u0005\u0011d!\u0001B+oSRDQAZ0A\u0002M\t\u0001\u0002]8tSRLwN\u001c\u0015\u0003?\"\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002nU\n9A/Y5me\u0016\u001c\u0007\"B8\u0001\t\u0013\u0001\u0018a\u00049s_\n,G)[:uC:\u001cWm\u00144\u0015\u0005M\t\b\"\u0002:o\u0001\u0004\u0019\u0012\u0001B:m_RDQa\u001c\u0001\u0005\u0012Q$2aE;x\u0011\u001518\u000f1\u0001\u0014\u0003%IG-Z1m'2|G\u000fC\u0003yg\u0002\u00071#\u0001\u0006bGR,\u0018\r\\*m_RDQA\u001f\u0001\u0005\nm\fA!\\8wKRQ!\r`?\u007f\u0003\u0003\t)!!\u0003\t\u000b\u0019L\b\u0019A\n\t\u000bQK\b\u0019\u0001\u0011\t\u000b}L\b\u0019A\n\u0002\u0003!Da!a\u0001z\u0001\u0004q\u0013!\u0002<bYV,\u0007BBA\u0004s\u0002\u00071#A\u0005fY\u0016lW\t]8dQ\"1\u00111B=A\u0002M\tQ\u0002\u001d:pE\u0016$\u0015n\u001d;b]\u000e,\u0007FA=i\u0011\u001d\t\t\u0002\u0001D\t\u0003'\tqaY8naV$X\rF\u0002/\u0003+Aa\u0001VA\b\u0001\u0004\u0001\u0003bBA\r\u0001\u0019E\u00111D\u0001\u0005Q\u0006\u001c\b\u000eF\u0002\u0014\u0003;Aa\u0001VA\f\u0001\u0004\u0001\u0003bBA\u0011\u0001\u0019E\u00111E\u0001\fSN\u001c\u0015m\u00195fC\ndW\r\u0006\u0003\u0002&\u0005-\u0002cA\u0006\u0002(%\u0019\u0011\u0011\u0006\u0007\u0003\u000f\t{w\u000e\\3b]\"9\u0011QFA\u0010\u0001\u0004q\u0013!\u0001<\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\u0005AAo\\*ue&tw\r\u0006\u0002\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012\u0001\u00027b]\u001eT!!a\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\nID\u0001\u0004TiJLgn\u001a")
public abstract class LruBoundedCache<K, V> {
    private final int capacity;
    public final int akka$remote$artery$LruBoundedCache$$evictAgeThreshold;
    public final int akka$remote$artery$LruBoundedCache$$Mask;
    public int akka$remote$artery$LruBoundedCache$$epoch;
    private final Object keys;
    private final V[] values;
    private final int[] hashes;
    private final int[] epochs;

    public final Option<V> get(K k) {
        int h = this.hash(k);
        return this.find$1(h & this.akka$remote$artery$LruBoundedCache$$Mask, 0, k, h);
    }

    public final CacheStatistics stats() {
        int sum = 0;
        int count = 0;
        int max = 0;
        for (int i = 0; i < this.hashes.length; ++i) {
            if (this.values[i] == null) continue;
            int dist = this.akka$remote$artery$LruBoundedCache$$probeDistanceOf(i);
            sum += dist;
            ++count;
            max = package$.MODULE$.max(dist, max);
        }
        return new CacheStatistics(count, max, (double)sum / (double)count);
    }

    public final V getOrCompute(K k) {
        int h = this.hash(k);
        ++this.akka$remote$artery$LruBoundedCache$$epoch;
        return (V)this.findOrCalculate$1(h & this.akka$remote$artery$LruBoundedCache$$Mask, 0, k, h);
    }

    /*
     * WARNING - void declaration
     */
    private void removeAt(int position) {
        while (true) {
            void var3_2;
            int next;
            if (this.values[next = position + 1 & this.akka$remote$artery$LruBoundedCache$$Mask] == null || this.akka$remote$artery$LruBoundedCache$$probeDistanceOf(next) == 0) {
                this.values[position] = null;
                return;
            }
            ScalaRunTime$.MODULE$.array_update(this.keys, position, ScalaRunTime$.MODULE$.array_apply(this.keys, (int)var3_2));
            this.values[position] = this.values[var3_2];
            this.hashes[position] = this.hashes[var3_2];
            this.epochs[position] = this.epochs[var3_2];
            position = var3_2;
        }
    }

    public int akka$remote$artery$LruBoundedCache$$probeDistanceOf(int slot) {
        return this.probeDistanceOf(this.hashes[slot] & this.akka$remote$artery$LruBoundedCache$$Mask, slot);
    }

    public int probeDistanceOf(int idealSlot, int actualSlot) {
        return actualSlot - idealSlot + this.capacity & this.akka$remote$artery$LruBoundedCache$$Mask;
    }

    private void move(int position, K k, int h, V value, int elemEpoch, int probeDistance) {
        while (true) {
            if (this.values[position] == null) {
                ScalaRunTime$.MODULE$.array_update(this.keys, position, k);
                this.values[position] = value;
                this.hashes[position] = h;
                this.epochs[position] = elemEpoch;
                return;
            }
            int otherEpoch = this.epochs[position];
            if (this.akka$remote$artery$LruBoundedCache$$epoch - otherEpoch >= this.akka$remote$artery$LruBoundedCache$$evictAgeThreshold) {
                this.removeAt(position);
                int n = h & this.akka$remote$artery$LruBoundedCache$$Mask;
                probeDistance = 0;
                position = n;
                continue;
            }
            int otherProbeDistance = this.akka$remote$artery$LruBoundedCache$$probeDistanceOf(position);
            int otherEpoch2 = this.epochs[position];
            if (probeDistance > otherProbeDistance) {
                Object otherKey = ScalaRunTime$.MODULE$.array_apply(this.keys, position);
                V otherValue = this.values[position];
                int otherHash = this.hashes[position];
                ScalaRunTime$.MODULE$.array_update(this.keys, position, k);
                this.values[position] = value;
                this.hashes[position] = h;
                this.epochs[position] = elemEpoch;
                probeDistance = otherProbeDistance + 1;
                elemEpoch = otherEpoch2;
                value = otherValue;
                h = otherHash;
                k = otherKey;
                position = position + 1 & this.akka$remote$artery$LruBoundedCache$$Mask;
                continue;
            }
            ++probeDistance;
            position = position + 1 & this.akka$remote$artery$LruBoundedCache$$Mask;
        }
    }

    public abstract V compute(K var1);

    public abstract int hash(K var1);

    public abstract boolean isCacheable(V var1);

    public String toString() {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LruBoundedCache("})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" values = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.values).mkString("[", ",", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" hashes = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(this.hashes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LruBoundedCache $outer;

            public final int apply(int x$1) {
                return this.apply$mcII$sp(x$1);
            }

            public int apply$mcII$sp(int x$1) {
                return x$1 & this.$outer.akka$remote$artery$LruBoundedCache$$Mask;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).mkString("[", ",", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" epochs = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(this.epochs).mkString("[", ",", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" distances = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.hashes.length).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LruBoundedCache $outer;

            public final int apply(int slot) {
                return this.apply$mcII$sp(slot);
            }

            public int apply$mcII$sp(int slot) {
                return this.$outer.akka$remote$artery$LruBoundedCache$$probeDistanceOf(slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ",", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.akka$remote$artery$LruBoundedCache$$epoch)}))).toString();
    }

    private final Option find$1(int position, int probeDistance, Object k$2, int h$1) {
        while (true) {
            block6: {
                None$ none$;
                block4: {
                    block5: {
                        int otherProbeDistance;
                        block3: {
                            otherProbeDistance = this.akka$remote$artery$LruBoundedCache$$probeDistanceOf(position);
                            if (this.values[position] != null) break block3;
                            none$ = None$.MODULE$;
                            break block4;
                        }
                        if (probeDistance <= otherProbeDistance) break block5;
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    if (this.hashes[position] != h$1 || !BoxesRunTime.equals((Object)k$2, (Object)ScalaRunTime$.MODULE$.array_apply(this.keys, position))) break block6;
                    none$ = new Some(this.values[position]);
                }
                return none$;
            }
            ++probeDistance;
            position = position + 1 & this.akka$remote$artery$LruBoundedCache$$Mask;
        }
    }

    private final Object findOrCalculate$1(int position, int probeDistance, Object k$1, int h$2) {
        while (true) {
            block9: {
                V v;
                block7: {
                    block8: {
                        block6: {
                            if (this.values[position] != null) break block6;
                            V value = this.compute(k$1);
                            if (this.isCacheable(value)) {
                                ScalaRunTime$.MODULE$.array_update(this.keys, position, k$1);
                                this.values[position] = value;
                                this.hashes[position] = h$2;
                                this.epochs[position] = this.akka$remote$artery$LruBoundedCache$$epoch;
                            }
                            v = value;
                            break block7;
                        }
                        int otherProbeDistance = this.akka$remote$artery$LruBoundedCache$$probeDistanceOf(position);
                        if (probeDistance <= otherProbeDistance) break block8;
                        V value = this.compute(k$1);
                        if (this.isCacheable(value)) {
                            this.move(position, k$1, h$2, value, this.akka$remote$artery$LruBoundedCache$$epoch, probeDistance);
                        }
                        v = value;
                        break block7;
                    }
                    if (this.hashes[position] != h$2 || !BoxesRunTime.equals((Object)k$1, (Object)ScalaRunTime$.MODULE$.array_apply(this.keys, position))) break block9;
                    this.epochs[position] = this.akka$remote$artery$LruBoundedCache$$epoch;
                    v = this.values[position];
                }
                return v;
            }
            ++probeDistance;
            position = position + 1 & this.akka$remote$artery$LruBoundedCache$$Mask;
        }
    }

    public LruBoundedCache(int capacity, int evictAgeThreshold, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        this.capacity = capacity;
        this.akka$remote$artery$LruBoundedCache$$evictAgeThreshold = evictAgeThreshold;
        Predef$.MODULE$.require(capacity > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Capacity must be larger than zero";
            }
        });
        Predef$.MODULE$.require((capacity & capacity - 1) == 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Capacity must be power of two";
            }
        });
        Predef$.MODULE$.require(evictAgeThreshold <= capacity, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Age threshold must be less than capacity.";
            }
        });
        this.akka$remote$artery$LruBoundedCache$$Mask = capacity - 1;
        this.akka$remote$artery$LruBoundedCache$$epoch = 0x7FFFFFFE;
        this.keys = Array$.MODULE$.ofDim(capacity, evidence$1);
        this.values = (Object[])Array$.MODULE$.ofDim(capacity, evidence$2);
        this.hashes = (int[])Array$.MODULE$.ofDim(capacity, ClassTag$.MODULE$.Int());
        this.epochs = (int[])Array$.MODULE$.fill(capacity, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LruBoundedCache $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.akka$remote$artery$LruBoundedCache$$epoch - this.$outer.akka$remote$artery$LruBoundedCache$$evictAgeThreshold;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Int());
    }
}

