/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.HttpErrorHandler;
import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class CustomErrorHandler
extends ErrorHandler {
    private final HttpErrorHandler[] handlers;

    public CustomErrorHandler() {
        this(new LicenseMissingErrorHandler());
    }

    public CustomErrorHandler(HttpErrorHandler ... handlers) {
        this.handlers = handlers;
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request2, HttpServletResponse response, int code, String message, String mimeType) throws IOException {
        Arrays.stream(this.handlers).filter(h -> h.canHandle(request2, code)).findFirst().ifPresent(h -> h.changeResponse(response));
        super.generateAcceptableResponse(baseRequest, request2, response, code, message, mimeType);
    }

    public void handleErrorPage(HttpServletRequest request2, Writer writer, int code, String message) throws IOException {
        Optional<HttpErrorHandler> handler = Arrays.stream(this.handlers).filter(h -> h.canHandle(request2, code)).findFirst();
        if (handler.isPresent()) {
            handler.get().writeErrorContent(writer);
        } else {
            super.handleErrorPage(request2, writer, code, message);
        }
    }
}

