/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.functions;

import com.hierynomus.msdtyp.MsDataTypes;
import com.hierynomus.ntlm.NtlmException;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class NtlmFunctions {
    static final byte[] LMOWFv1_SECRET = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    public static final Charset UNICODE = StandardCharsets.UTF_16LE;
    private static SecureRandom secureRandom = new SecureRandom();

    public static byte[] NTOWFv2(String password, String username, String userDomain) {
        byte[] keyBytes = NtlmFunctions.NTOWFv1(password, username, userDomain);
        byte[] usernameBytes = NtlmFunctions.unicode(username.toUpperCase());
        byte[] userDomainBytes = NtlmFunctions.unicode(userDomain);
        return NtlmFunctions.hmac_md5(keyBytes, usernameBytes, userDomainBytes);
    }

    public static byte[] LMOWFv2(String password, String username, String userDomain) {
        return NtlmFunctions.NTOWFv2(password, username, userDomain);
    }

    public static byte[] NTOWFv1(String password, String username, String userDomain) {
        byte[] bytes = NtlmFunctions.unicode(password);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD4", "BC");
            digest.update(bytes);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new NtlmException(e);
        }
    }

    public static byte[] unicode(String string) {
        return string == null ? new byte[]{} : string.getBytes(UNICODE);
    }

    public static byte[] hmac_md5(byte[] key, byte[] ... message) {
        try {
            Mac hmacMD5 = Mac.getInstance("HmacMD5", "BC");
            hmacMD5.init(new SecretKeySpec(key, "HmacMD5"));
            for (int i = 0; i < message.length; ++i) {
                hmacMD5.update(message[i]);
            }
            return hmacMD5.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new NtlmException(e);
        }
    }

    public static byte[] LMOWFv1(String password, String username, String userDomain) {
        try {
            byte[] bytes = password.toUpperCase().getBytes("US-ASCII");
            if (bytes.length != 14) {
                bytes = Arrays.copyOf(bytes, 14);
            }
            Cipher leftCipher = NtlmFunctions.getDESCipher(Arrays.copyOfRange(bytes, 0, 7));
            Cipher rightCipher = NtlmFunctions.getDESCipher(Arrays.copyOfRange(bytes, 7, 14));
            byte[] firstBytes = leftCipher.doFinal(LMOWFv1_SECRET);
            byte[] lastBytes = rightCipher.doFinal(LMOWFv1_SECRET);
            byte[] lmHash = new byte[16];
            System.arraycopy(firstBytes, 0, lmHash, 0, firstBytes.length);
            System.arraycopy(lastBytes, 0, lmHash, firstBytes.length, lastBytes.length);
            return lmHash;
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            throw new NtlmException(e);
        }
    }

    public static byte[] getNTLMv2ClientChallenge(byte[] targetInformation) {
        byte[] challengeFromClient = new byte[8];
        NtlmFunctions.getRandom().nextBytes(challengeFromClient);
        long nowAsFileTime = MsDataTypes.nowAsFileTime();
        byte[] l_targetInfo = targetInformation == null ? new byte[]{} : targetInformation;
        Buffer.PlainBuffer ccBuf = new Buffer.PlainBuffer(Endian.LE);
        ccBuf.putByte((byte)1);
        ccBuf.putByte((byte)1);
        ccBuf.putUInt16(0);
        ccBuf.putUInt32(0L);
        ccBuf.putLong(nowAsFileTime);
        ccBuf.putRawBytes(challengeFromClient);
        ccBuf.putUInt32(0L);
        ccBuf.putRawBytes(l_targetInfo);
        ccBuf.putUInt32(0L);
        return ccBuf.getCompactData();
    }

    public static byte[] getNTLMv2Response(byte[] responseKeyNT, byte[] serverChallenge, byte[] ntlmv2ClientChallenge) {
        byte[] ntProofStr = NtlmFunctions.hmac_md5(responseKeyNT, serverChallenge, ntlmv2ClientChallenge);
        byte[] ntChallengeResponse = new byte[ntProofStr.length + ntlmv2ClientChallenge.length];
        System.arraycopy(ntProofStr, 0, ntChallengeResponse, 0, ntProofStr.length);
        System.arraycopy(ntlmv2ClientChallenge, 0, ntChallengeResponse, ntProofStr.length, ntlmv2ClientChallenge.length);
        return ntChallengeResponse;
    }

    public static byte[] encryptRc4(byte[] key, byte[] val) throws NtlmException {
        try {
            Cipher c = NtlmFunctions.getRC4Cipher(key);
            byte[] enc = c.doFinal(val);
            return enc;
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new NtlmException(e);
        }
    }

    public static SecureRandom getRandom() {
        return secureRandom;
    }

    public static void setRandom(SecureRandom sRandom) {
        if (sRandom != null) {
            secureRandom = sRandom;
        }
    }

    private static byte[] setupKey(byte[] key56) {
        byte[] key = new byte[]{(byte)(key56[0] >> 1 & 0xFF), (byte)(((key56[0] & 1) << 6 | (key56[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((key56[1] & 3) << 5 | (key56[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((key56[2] & 7) << 4 | (key56[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((key56[3] & 0xF) << 3 | (key56[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((key56[4] & 0x1F) << 2 | (key56[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((key56[5] & 0x3F) << 1 | (key56[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(key56[6] & 0x7F)};
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)(key[i] << 1);
        }
        return key;
    }

    private static Cipher getDESCipher(byte[] key) {
        try {
            Cipher bc = Cipher.getInstance("DES/ECB/NoPadding", "BC");
            SecretKeySpec des = new SecretKeySpec(NtlmFunctions.setupKey(key), "DES");
            bc.init(1, des);
            return bc;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new NtlmException(e);
        }
    }

    private static Cipher getRC4Cipher(byte[] key) {
        try {
            Cipher bc = Cipher.getInstance("RC4", "BC");
            SecretKeySpec rc4 = new SecretKeySpec(key, "RC4");
            bc.init(1, rc4);
            return bc;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new NtlmException(e);
        }
    }
}

