/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp;

import com.hierynomus.msdtyp.ACL;
import com.hierynomus.msdtyp.SID;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.EnumSet;

public class SecurityDescriptor {
    private EnumSet<Control> control;
    private SID ownerSid;
    private SID groupSid;
    private ACL sacl;
    private ACL dacl;

    public void write(SMBBuffer buffer) {
    }

    public void read(SMBBuffer buffer) throws Buffer.BufferException {
        buffer.readByte();
        buffer.readByte();
        this.control = EnumWithValue.EnumUtils.toEnumSet(buffer.readUInt16(), Control.class);
        int ownerOffset = buffer.readUInt32AsInt();
        int groupOffset = buffer.readUInt32AsInt();
        int saclOffset = buffer.readUInt32AsInt();
        int daclOffset = buffer.readUInt32AsInt();
        if (ownerOffset > 0) {
            buffer.rpos(ownerOffset);
            this.ownerSid = new SID();
            this.ownerSid.read(buffer);
        }
        if (groupOffset > 0) {
            buffer.rpos(groupOffset);
            this.groupSid = new SID();
            this.groupSid.read(buffer);
        }
        if (saclOffset > 0) {
            buffer.rpos(saclOffset);
            this.sacl = new ACL();
            this.sacl.read(buffer);
        }
        if (daclOffset > 0) {
            buffer.rpos(daclOffset);
            this.dacl = new ACL();
            this.dacl.read(buffer);
        }
    }

    public EnumSet<Control> getControl() {
        return this.control;
    }

    public SID getOwnerSid() {
        return this.ownerSid;
    }

    public SID getGroupSid() {
        return this.groupSid;
    }

    public ACL getSacl() {
        return this.sacl;
    }

    public ACL getDacl() {
        return this.dacl;
    }

    public String toString() {
        return "SecurityDescriptor{control=" + this.control + ", ownerSid=" + this.ownerSid + ", groupSid=" + this.groupSid + ", sacl=" + this.sacl + ", dacl=" + this.dacl + '}';
    }

    public static enum Control implements EnumWithValue<Control>
    {
        NONE(0L),
        SR(1L),
        RM(2L),
        PS(4L),
        PD(8L),
        SI(16L),
        DI(32L),
        SC(64L),
        DC(128L),
        DT(256L),
        SS(512L),
        SD(1024L),
        SP(2048L),
        DD(4096L),
        DP(8192L),
        GD(16384L),
        OD(32768L);

        private long value;

        private Control(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }
}

