/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.FocusPolicyMemento;
import com.jeta.forms.store.memento.FormGroupSet;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.support.Matrix;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class FormMemento
extends ComponentMemento {
    static final long serialVersionUID = -7808404997780438089L;
    public static final int VERSION = 5;
    private String m_row_specs;
    private String m_column_specs;
    private LinkedList m_components = new LinkedList();
    private PropertiesMemento m_properties_memento;
    private String m_path;
    private String m_id;
    private Matrix m_cell_painters;
    private FormGroupSet m_row_groups;
    private FormGroupSet m_column_groups;
    private FocusPolicyMemento m_focus_policy;
    private HashMap m_properties = new HashMap();

    public void addComponent(ComponentMemento componentMemento) {
        this.m_components.add(componentMemento);
    }

    public Matrix getCellPainters() {
        return this.m_cell_painters;
    }

    public FormGroupSet getColumnGroups() {
        return this.m_column_groups;
    }

    public String getColumnSpecs() {
        return this.m_column_specs;
    }

    public FocusPolicyMemento getFocusPolicy() {
        return this.m_focus_policy;
    }

    public String getId() {
        return this.m_id;
    }

    public PropertiesMemento getPropertiesMemento() {
        return this.m_properties_memento;
    }

    public HashMap getProperties() {
        return this.m_properties;
    }

    public String getRelativePath() {
        return this.m_path;
    }

    public FormGroupSet getRowGroups() {
        return this.m_row_groups;
    }

    public String getRowSpecs() {
        return this.m_row_specs;
    }

    public Iterator iterator() {
        return this.m_components.iterator();
    }

    public void print() {
        System.out.println(" >>>>>>>>>>>>>>>>>  FormMemento state >>>>>>>>>>>>>> ");
        System.out.println("rowSpecs: " + this.m_row_specs);
        System.out.println("colSpecs: " + this.m_column_specs);
        System.out.println(" ----------- comp mementos --------- ");
        Iterator iterator = this.m_components.iterator();
        while (iterator.hasNext()) {
            ComponentMemento componentMemento = (ComponentMemento)iterator.next();
            componentMemento.print();
        }
    }

    public void setCellPainters(Matrix matrix) {
        this.m_cell_painters = matrix;
    }

    public void setColumnGroups(FormGroupSet formGroupSet) {
        this.m_column_groups = formGroupSet;
    }

    public void setColumnSpecs(String string) {
        this.m_column_specs = string;
    }

    public void setFocusPolicy(FocusPolicyMemento focusPolicyMemento) {
        this.m_focus_policy = focusPolicyMemento;
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public void setRelativePath(String string) {
        this.m_path = string;
    }

    public void setRowGroups(FormGroupSet formGroupSet) {
        this.m_row_groups = formGroupSet;
    }

    public void setProperties(HashMap hashMap) {
        this.m_properties = hashMap;
    }

    public void setPropertiesMemento(PropertiesMemento propertiesMemento) {
        this.m_properties_memento = propertiesMemento;
    }

    public void setRowSpecs(String string) {
        this.m_row_specs = string;
    }

    public int size() {
        return this.m_components.size();
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_id = (String)jETAObjectInput.readObject("id");
        this.m_path = (String)jETAObjectInput.readObject("path");
        if (FormUtils.isDesignMode()) {
            this.m_path = FormUtils.fixPath(this.m_path);
        }
        this.m_row_specs = (String)jETAObjectInput.readObject("rowspecs");
        this.m_column_specs = (String)jETAObjectInput.readObject("colspecs");
        this.m_components = (LinkedList)jETAObjectInput.readObject("components");
        if (n >= 5) {
            this.m_properties_memento = (PropertiesMemento)jETAObjectInput.readObject("properties");
        } else {
            this.m_properties = (HashMap)jETAObjectInput.readObject("properties");
        }
        if (n >= 2) {
            this.m_cell_painters = (Matrix)jETAObjectInput.readObject("cellpainters");
        }
        if (n >= 3) {
            this.m_focus_policy = (FocusPolicyMemento)jETAObjectInput.readObject("focuspolicy");
            this.m_focus_policy = null;
        }
        if (n >= 4) {
            this.m_row_groups = (FormGroupSet)jETAObjectInput.readObject("rowgroups");
            this.m_column_groups = (FormGroupSet)jETAObjectInput.readObject("colgroups");
        }
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(ComponentMemento.class));
        jETAObjectOutput.writeVersion(5);
        jETAObjectOutput.writeObject("id", this.m_id);
        jETAObjectOutput.writeObject("path", this.m_path);
        jETAObjectOutput.writeObject("rowspecs", this.m_row_specs);
        jETAObjectOutput.writeObject("colspecs", this.m_column_specs);
        jETAObjectOutput.writeObject("components", this.m_components);
        jETAObjectOutput.writeObject("properties", this.m_properties_memento);
        jETAObjectOutput.writeObject("cellpainters", this.m_cell_painters);
        jETAObjectOutput.writeObject("focuspolicy", this.m_focus_policy);
        jETAObjectOutput.writeObject("rowgroups", this.m_row_groups);
        jETAObjectOutput.writeObject("colgroups", this.m_column_groups);
    }
}

