/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.util.logging.Log;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static Element nextElement(ConfigurationReader reader) throws ConfigurationReaderException {
        if (reader.nextElement() == ConfigurationReader.ElementType.END_ELEMENT) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public static ConfigurationReaderException unexpectedElement(ConfigurationReader reader) {
        return new ConfigurationReaderException("Unexpected element '" + reader.getLocalName() + "' encountered", reader.getLocation());
    }

    public static <T extends Enum<T>> ConfigurationReaderException unexpectedElement(ConfigurationReader reader, T element) {
        return ParseUtils.unexpectedElement(reader, element.toString());
    }

    public static ConfigurationReaderException unexpectedElement(ConfigurationReader reader, String element) {
        return new ConfigurationReaderException("Unexpected element '" + element + "' encountered", reader.getLocation());
    }

    public static ConfigurationReaderException unexpectedEndElement(ConfigurationReader reader) {
        return new ConfigurationReaderException("Unexpected end of element '" + reader.getLocalName() + "' encountered", reader.getLocation());
    }

    public static ConfigurationReaderException unexpectedAttribute(ConfigurationReader reader, int index) {
        return new ConfigurationReaderException("Unexpected attribute '" + reader.getAttributeName(index) + "' encountered", reader.getLocation());
    }

    public static ConfigurationReaderException unexpectedAttribute(ConfigurationReader reader, String name) {
        return new ConfigurationReaderException("Unexpected attribute '" + name + "' encountered", reader.getLocation());
    }

    public static ConfigurationReaderException invalidAttributeValue(ConfigurationReader reader, int index) {
        return new ConfigurationReaderException("Invalid value '" + reader.getAttributeValue(index) + "' for attribute '" + reader.getAttributeName(index) + "'", reader.getLocation());
    }

    public static ConfigurationReaderException missingRequired(ConfigurationReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new ConfigurationReaderException("Missing required attribute(s): " + String.valueOf(b), reader.getLocation());
    }

    public static ConfigurationReaderException missingRequiredElement(ConfigurationReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new ConfigurationReaderException("Missing required element(s): " + String.valueOf(b), reader.getLocation());
    }

    public static void requireNoAttributes(ConfigurationReader reader) throws ConfigurationReaderException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
    }

    public static void requireNoContent(ConfigurationReader reader) throws ConfigurationReaderException {
        if (reader.hasNext() && reader.nextElement() != ConfigurationReader.ElementType.END_ELEMENT) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static ConfigurationReaderException duplicateAttribute(ConfigurationReader reader, String name) {
        return new ConfigurationReaderException("An attribute named '" + name + "' has already been declared", reader.getLocation());
    }

    public static ConfigurationReaderException duplicateNamedElement(ConfigurationReader reader, String name) {
        return new ConfigurationReaderException("An element of this type named '" + name + "' has already been declared", reader.getLocation());
    }

    public static boolean readBooleanAttributeElement(ConfigurationReader reader, String attributeName) throws ConfigurationReaderException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String readStringAttributeElement(ConfigurationReader reader, String attributeName) throws ConfigurationReaderException {
        String value = ParseUtils.requireSingleAttribute(reader, attributeName);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String requireSingleAttribute(ConfigurationReader reader, String attributeName) throws ConfigurationReaderException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(attributeName));
        }
        ParseUtils.requireNoNamespaceAttribute(reader, 0);
        if (!attributeName.equals(reader.getAttributeName(0))) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw ParseUtils.unexpectedAttribute(reader, 1);
        }
        return reader.getAttributeValue(0);
    }

    public static String requireSingleAttribute(ConfigurationReader reader, Enum<?> attribute) throws ConfigurationReaderException {
        return ParseUtils.requireSingleAttribute(reader, attribute.toString());
    }

    public static String[] requireAttributes(ConfigurationReader reader, boolean replace, String ... attributeNames) throws ConfigurationReaderException {
        int length = attributeNames.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            String name = attributeNames[i];
            String value = reader.getAttributeValue(name);
            if (value == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(name));
            }
            result[i] = replace ? StringPropertyReplacer.replaceProperties((String)value) : value;
        }
        return result;
    }

    public static String[] requireAttributes(ConfigurationReader reader, String ... attributeNames) throws ConfigurationReaderException {
        return ParseUtils.requireAttributes(reader, false, attributeNames);
    }

    public static String[] requireAttributes(ConfigurationReader reader, Enum<?> ... attributes) throws ConfigurationReaderException {
        String[] attributeNames = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributeNames[i] = attributes[i].toString();
        }
        return ParseUtils.requireAttributes(reader, true, attributeNames);
    }

    public static boolean isNoNamespaceAttribute(ConfigurationReader reader, int index) {
        String namespace = reader.getAttributeNamespace(index);
        return namespace == null || namespace.isEmpty();
    }

    public static void requireNoNamespaceAttribute(ConfigurationReader reader, int index) throws ConfigurationReaderException {
        if (!ParseUtils.isNoNamespaceAttribute(reader, index)) {
            throw ParseUtils.unexpectedAttribute(reader, index);
        }
    }

    public static Namespace[] getNamespaceAnnotations(Class<?> cls) {
        Namespaces namespacesAnnotation = cls.getAnnotation(Namespaces.class);
        if (namespacesAnnotation != null) {
            return namespacesAnnotation.value();
        }
        Namespace namespaceAnnotation = cls.getAnnotation(Namespace.class);
        if (namespaceAnnotation != null) {
            return new Namespace[]{namespaceAnnotation};
        }
        return null;
    }

    public static String[] getListAttributeValue(String value) {
        return value.split("\\s+");
    }

    public static String resolvePath(String path, String relativeTo) {
        if (path == null) {
            return null;
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (relativeTo != null) {
            return new File(new File(relativeTo), path).getAbsolutePath();
        }
        return path;
    }

    public static String requireAttributeProperty(ConfigurationReader reader, int i) throws ConfigurationReaderException {
        String property = reader.getAttributeValue(i);
        Object value = reader.getProperty(property);
        if (value == null) {
            throw Log.CONFIG.missingRequiredProperty(property, reader.getAttributeName(i), reader.getLocation());
        }
        return value.toString();
    }

    public static void ignoreAttribute(ConfigurationReader reader, String attributeName) {
        Log.CONFIG.ignoreAttribute(attributeName, reader.getLocation());
    }

    public static void ignoreAttribute(ConfigurationReader reader, int attributeIndex) {
        ParseUtils.ignoreAttribute(reader, reader.getAttributeName(attributeIndex));
    }

    public static void ignoreAttribute(ConfigurationReader reader, Enum<?> attribute) {
        Log.CONFIG.ignoreAttribute(attribute, reader.getLocation());
    }

    public static void ignoreElement(ConfigurationReader reader, Enum<?> element) {
        Log.CONFIG.ignoreXmlElement(element, reader.getLocation());
    }

    public static CacheConfigurationException elementRemoved(ConfigurationReader reader, String newElementName) {
        return Log.CONFIG.elementRemovedUseOther(reader.getLocalName(), newElementName, reader.getLocation());
    }

    public static CacheConfigurationException elementRemoved(ConfigurationReader reader) {
        return Log.CONFIG.elementRemoved(reader.getLocalName(), reader.getLocation());
    }

    public static CacheConfigurationException attributeRemoved(ConfigurationReader reader, int attributeIndex, String newAttributeName) {
        String attributeName = reader.getAttributeName(attributeIndex);
        return Log.CONFIG.attributeRemovedUseOther(attributeName, newAttributeName, reader.getLocation());
    }

    public static CacheConfigurationException attributeRemoved(ConfigurationReader reader, int attributeIndex) {
        String attributeName = reader.getAttributeName(attributeIndex);
        return Log.CONFIG.attributeRemoved(attributeName, reader.getLocation());
    }

    public static void parseAttributes(ConfigurationReader reader, Builder<?> builder) {
        AttributeSet attributes = builder.attributes();
        attributes.touch();
        int major = reader.getSchema().getMajor();
        int minor = reader.getSchema().getMinor();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = attributes.attribute(name);
            if (attribute == null) {
                if (attributes.isRemoved(name, major, minor)) {
                    Log.CONFIG.ignoreAttribute(name, reader.getLocation());
                    continue;
                }
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            try {
                attribute.fromString(value);
                if (!attribute.getAttributeDefinition().isDeprecated(major, minor)) continue;
                Log.CONFIG.attributeDeprecated(attribute.name(), attributes.getName(), major, minor);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw Log.CONFIG.invalidAttributeValue(reader.getLocalName(), name, value, reader.getLocation(), e.getLocalizedMessage());
            }
        }
    }

    public static Integer parseInt(ConfigurationReader reader, int i, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (IllegalArgumentException e) {
            throw Log.CONFIG.invalidAttributeValue(reader.getLocalName(), reader.getAttributeName(i), value, reader.getLocation(), e.getLocalizedMessage());
        }
    }

    public static long parseLong(ConfigurationReader reader, int i, String value) {
        try {
            return Long.parseLong(value);
        }
        catch (IllegalArgumentException e) {
            throw Log.CONFIG.invalidAttributeValue(reader.getLocalName(), reader.getAttributeName(i), value, reader.getLocation(), e.getLocalizedMessage());
        }
    }

    public static <T extends Enum<T>> T parseEnum(ConfigurationReader reader, int i, Class<T> enumClass, String value) {
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            throw Log.CONFIG.invalidAttributeEnumValue(reader.getLocalName(), reader.getAttributeName(i), value, EnumSet.allOf(enumClass).toString(), reader.getLocation());
        }
    }

    public static boolean parseBoolean(ConfigurationReader reader, int i, String value) {
        try {
            return Util.parseBoolean((String)value);
        }
        catch (IllegalArgumentException e) {
            throw Log.CONFIG.invalidAttributeValue(reader.getLocalName(), reader.getAttributeName(i), value, reader.getLocation(), e.getLocalizedMessage());
        }
    }
}

