/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.shared.common.error.StandardException;

public class HarmonySerialBlob
implements Blob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8144641928112860441L;
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;

    public HarmonySerialBlob(Blob blob) throws SQLException {
        if (blob == null) {
            throw new IllegalArgumentException();
        }
        this.blob = blob;
        this.buf = blob.getBytes(1L, (int)blob.length());
        this.origLen = this.len = (long)this.buf.length;
    }

    public HarmonySerialBlob(byte[] byArray) {
        this.buf = new byte[byArray.length];
        this.origLen = this.len = (long)byArray.length;
        System.arraycopy(byArray, 0, this.buf, 0, (int)this.len);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || l > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{l});
        }
        if (n < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{n});
        }
        if ((long)n > this.len - l + 1L) {
            n = (int)(this.len - l + 1L);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, (int)l - 1, byArray, 0, n);
        return byArray;
    }

    @Override
    public long length() throws SQLException {
        return this.len;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l);
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 1L || this.len - (l - 1L) < (long)byArray.length) {
            return -1L;
        }
        int n = (int)(l - 1L);
        while ((long)n <= this.len - (long)byArray.length) {
            if (this.match(this.buf, n, byArray)) {
                return n + 1;
            }
            ++n;
        }
        return -1L;
    }

    private boolean match(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.blob == null) {
            throw new IllegalStateException();
        }
        OutputStream outputStream = this.blob.setBinaryStream(l);
        if (outputStream == null) {
            throw new IllegalStateException();
        }
        return outputStream;
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (l < 1L || n2 < 0 || l > this.len - (long)n2 + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{l});
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", new Object[]{n});
        }
        System.arraycopy(byArray, n, this.buf, (int)l - 1, n2);
        return n2;
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (l > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{this.len});
        }
        this.buf = this.getBytes(1L, (int)l);
        this.len = l;
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (this.len < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{this.len});
        }
        if (l2 < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{l2});
        }
        if (l < 1L || l + l2 - 1L > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ087.S", new Object[]{l, l2});
        }
        return new ByteArrayInputStream(this.buf, (int)(l - 1L), (int)l2);
    }

    public static SQLException makeSQLException(String string, Object[] objectArray) {
        StandardException standardException = StandardException.newException(string, objectArray);
        return new SQLException(standardException.getMessage(), standardException.getSQLState());
    }
}

