/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.engine.spi.ComparableExecutable;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.util.collections.CollectionHelper;

public class ExecutableList<@UnknownKeyFor E extends @UnknownKeyFor @NonNull @Initialized ComparableExecutable>
implements Serializable,
Iterable<E>,
Externalizable {
    public static final @UnknownKeyFor @NonNull @Initialized int INIT_QUEUE_LIST_SIZE = 5;
    private final @UnknownKeyFor @NonNull @Initialized ArrayList<E> executables;
    private final @Nullable @UnknownKeyFor @Initialized Sorter<E> sorter;
    private final @UnknownKeyFor @NonNull @Initialized boolean requiresSorting;
    private @UnknownKeyFor @NonNull @Initialized boolean sorted;
    private transient @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized Serializable> querySpaces;

    public ExecutableList() {
        this(5);
    }

    public ExecutableList(@UnknownKeyFor @NonNull @Initialized int initialCapacity) {
        this(initialCapacity, true);
    }

    public ExecutableList(@UnknownKeyFor @NonNull @Initialized boolean requiresSorting) {
        this(5, requiresSorting);
    }

    public ExecutableList(@UnknownKeyFor @NonNull @Initialized int initialCapacity, @UnknownKeyFor @NonNull @Initialized boolean requiresSorting) {
        this.sorter = null;
        this.executables = new ArrayList(initialCapacity);
        this.querySpaces = null;
        this.requiresSorting = requiresSorting;
        this.sorted = requiresSorting;
    }

    public ExecutableList(@UnknownKeyFor @NonNull @Initialized Sorter<E> sorter) {
        this(5, sorter);
    }

    public ExecutableList(@UnknownKeyFor @NonNull @Initialized int initialCapacity, @UnknownKeyFor @NonNull @Initialized Sorter<E> sorter) {
        this.sorter = sorter;
        this.executables = new ArrayList(initialCapacity);
        this.querySpaces = null;
        this.requiresSorting = true;
        this.sorted = true;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Serializable> getQuerySpaces() {
        if (this.querySpaces == null) {
            for (ComparableExecutable e : this.executables) {
                String[] propertySpaces = e.getPropertySpaces();
                if (propertySpaces == null || propertySpaces.length <= 0) continue;
                if (this.querySpaces == null) {
                    this.querySpaces = new HashSet<Serializable>();
                }
                Collections.addAll(this.querySpaces, propertySpaces);
            }
            if (this.querySpaces == null) {
                return Collections.emptySet();
            }
        }
        return this.querySpaces;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.executables.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized ComparableExecutable remove(@UnknownKeyFor @NonNull @Initialized int index) {
        ComparableExecutable e = (ComparableExecutable)this.executables.remove(index);
        if (e.getPropertySpaces() != null && e.getPropertySpaces().length > 0) {
            this.querySpaces = null;
        }
        return e;
    }

    public void clear() {
        this.executables.clear();
        this.querySpaces = null;
        this.sorted = this.requiresSorting;
    }

    public void removeLastN(@UnknownKeyFor @NonNull @Initialized int n) {
        if (n > 0) {
            int size = this.executables.size();
            for (ComparableExecutable e : this.executables.subList(size - n, size)) {
                if (e.getPropertySpaces() == null || e.getPropertySpaces().length <= 0) continue;
                this.querySpaces = null;
                break;
            }
            this.executables.subList(size - n, size).clear();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean add(E executable) {
        ComparableExecutable previousLast = this.sorter != null || this.executables.isEmpty() ? null : (ComparableExecutable)this.executables.get(this.executables.size() - 1);
        boolean added = this.executables.add(executable);
        if (!added) {
            return false;
        }
        if (this.sorted) {
            if (this.sorter != null) {
                this.sorted = false;
            } else if (previousLast != null && previousLast.compareTo(executable) > 0) {
                this.sorted = false;
            }
        }
        String[] querySpaces = executable.getPropertySpaces();
        if (this.querySpaces != null && querySpaces != null) {
            Collections.addAll(this.querySpaces, querySpaces);
        }
        return true;
    }

    public void sort() {
        if (this.sorted || !this.requiresSorting) {
            return;
        }
        if (this.sorter != null) {
            this.sorter.sort(this.executables);
        } else {
            Collections.sort(this.executables);
        }
        this.sorted = true;
    }

    public @UnknownKeyFor @NonNull @Initialized int size() {
        return this.executables.size();
    }

    public E get(@UnknownKeyFor @NonNull @Initialized int index) {
        return (E)((ComparableExecutable)this.executables.get(index));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<E> iterator() {
        return Collections.unmodifiableList(this.executables).iterator();
    }

    @Override
    public void writeExternal(@UnknownKeyFor @NonNull @Initialized ObjectOutput oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        oos.writeBoolean(this.sorted);
        oos.writeInt(this.executables.size());
        for (ComparableExecutable e : this.executables) {
            oos.writeObject(e);
        }
        if (this.querySpaces == null) {
            oos.writeInt(-1);
        } else {
            Set<Serializable> qs = this.querySpaces;
            oos.writeInt(this.querySpaces.size());
            for (Serializable querySpace : qs) {
                oos.writeUTF(querySpace.toString());
            }
        }
    }

    @Override
    public void readExternal(@UnknownKeyFor @NonNull @Initialized ObjectInput in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        int numberOfQuerySpaces;
        this.sorted = in.readBoolean();
        int numberOfExecutables = in.readInt();
        this.executables.ensureCapacity(numberOfExecutables);
        if (numberOfExecutables > 0) {
            for (int i = 0; i < numberOfExecutables; ++i) {
                ComparableExecutable e = (ComparableExecutable)in.readObject();
                this.executables.add(e);
            }
        }
        if ((numberOfQuerySpaces = in.readInt()) < 0) {
            this.querySpaces = null;
        } else {
            HashSet querySpaces = CollectionHelper.setOfSize(numberOfQuerySpaces);
            for (int i = 0; i < numberOfQuerySpaces; ++i) {
                querySpaces.add(in.readUTF());
            }
            this.querySpaces = querySpaces;
        }
    }

    public void afterDeserialize(@UnknownKeyFor @NonNull @Initialized EventSource session) {
        for (ComparableExecutable e : this.executables) {
            e.afterDeserialize(session);
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "ExecutableList{size=" + this.executables.size() + "}";
    }

    public static interface Sorter<@UnknownKeyFor ComparableExecutable> {
        public void sort(@UnknownKeyFor @NonNull @Initialized List<ComparableExecutable> var1);
    }
}

