/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.update.Update;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JSqlParserUtils;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.SerializationUtils;
import org.springframework.util.StringUtils;

public class JSqlParserQueryEnhancer
implements QueryEnhancer {
    private final DeclaredQuery query;
    private final Statement statement;
    private final ParsedType parsedType;
    private final boolean hasConstructorExpression;
    @Nullable
    private final String primaryAlias;
    private final String projection;
    private final Set<String> joinAliases;
    private final Set<String> selectAliases;
    private final byte[] serialized;

    public JSqlParserQueryEnhancer(DeclaredQuery query) {
        this.query = query;
        this.statement = JSqlParserQueryEnhancer.parseStatement(query.getQueryString(), Statement.class);
        this.parsedType = JSqlParserQueryEnhancer.detectParsedType(this.statement);
        this.hasConstructorExpression = QueryUtils.hasConstructorExpression(query.getQueryString());
        this.primaryAlias = JSqlParserQueryEnhancer.detectAlias(this.parsedType, this.statement);
        this.projection = JSqlParserQueryEnhancer.detectProjection(this.statement);
        this.selectAliases = Collections.unmodifiableSet(JSqlParserQueryEnhancer.getSelectionAliases(this.statement));
        this.joinAliases = Collections.unmodifiableSet(JSqlParserQueryEnhancer.getJoinAliases(this.statement));
        this.serialized = SerializationUtils.serialize((Object)this.statement);
    }

    static <T extends Statement> T parseStatement(String sql, Class<T> classOfT) {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser((String)sql);
            boolean allowComplex = parser.getConfiguration().getAsBoolean(Feature.allowComplexParsing);
            try {
                return (T)((Statement)classOfT.cast(((CCJSqlParser)parser.withAllowComplexParsing(true)).Statement()));
            }
            catch (ParseException ex) {
                if (allowComplex && CCJSqlParserUtil.getNestingDepth((String)sql) <= 10) {
                    parser = CCJSqlParserUtil.newParser((String)sql);
                    return (T)((Statement)classOfT.cast(((CCJSqlParser)parser.withAllowComplexParsing(true)).Statement()));
                }
                throw ex;
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The query you provided is not a valid SQL Query", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static String detectAlias(ParsedType parsedType, Statement statement) {
        if (ParsedType.MERGE.equals((Object)parsedType)) {
            Merge mergeStatement = (Merge)statement;
            Alias alias = mergeStatement.getUsingAlias();
            return alias == null ? null : alias.getName();
        }
        if (ParsedType.SELECT.equals((Object)parsedType)) {
            void selectBody;
            Select selectStatement = (Select)statement;
            if (!(selectStatement instanceof PlainSelect)) {
                return null;
            }
            PlainSelect alias = (PlainSelect)selectStatement;
            if (selectBody.getFromItem() == null) {
                return null;
            }
            Alias alias2 = selectBody.getFromItem().getAlias();
            return alias2 == null ? null : alias2.getName();
        }
        return null;
    }

    private static Set<String> getSelectionAliases(Statement statement) {
        PlainSelect select;
        if (!(statement instanceof PlainSelect) || CollectionUtils.isEmpty((Collection)(select = (PlainSelect)statement).getSelectItems())) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(select.getSelectItems().size());
        for (SelectItem selectItem : select.getSelectItems()) {
            Alias alias = selectItem.getAlias();
            if (alias == null) continue;
            set.add(alias.getName());
        }
        return set;
    }

    private static Set<String> getJoinAliases(Statement statement) {
        PlainSelect selectBody;
        if (!(statement instanceof PlainSelect) || CollectionUtils.isEmpty((Collection)(selectBody = (PlainSelect)statement).getJoins())) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(selectBody.getJoins().size());
        for (Join join : selectBody.getJoins()) {
            Alias alias = join.getRightItem().getAlias();
            if (alias == null) continue;
            set.add(alias.getName());
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static String detectProjection(Statement statement) {
        SetOperationList setOperationList;
        void select;
        if (!(statement instanceof Select)) {
            return "";
        }
        Select select2 = (Select)statement;
        if (select instanceof Values) {
            return "";
        }
        Select selectBody = select;
        if (select instanceof SetOperationList && !((selectBody = (Select)(setOperationList = (SetOperationList)select).getSelects().get(0)) instanceof PlainSelect)) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (SelectItem selectItem : ((PlainSelect)selectBody).getSelectItems()) {
            joiner.add(selectItem.toString());
        }
        return joiner.toString().trim();
    }

    private static ParsedType detectParsedType(Statement statement) {
        if (statement instanceof Insert) {
            return ParsedType.INSERT;
        }
        if (statement instanceof Update) {
            return ParsedType.UPDATE;
        }
        if (statement instanceof Delete) {
            return ParsedType.DELETE;
        }
        if (statement instanceof Select) {
            return ParsedType.SELECT;
        }
        if (statement instanceof Merge) {
            return ParsedType.MERGE;
        }
        return ParsedType.OTHER;
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    @Override
    public String detectAlias() {
        return this.primaryAlias;
    }

    @Override
    public String getProjection() {
        return this.projection;
    }

    @Override
    public Set<String> getJoinAliases() {
        return this.joinAliases;
    }

    public Set<String> getSelectionAliases() {
        return this.selectAliases;
    }

    @Override
    public DeclaredQuery getQuery() {
        return this.query;
    }

    @Override
    public String applySorting(Sort sort) {
        return this.applySorting(sort, this.detectAlias());
    }

    @Override
    public String applySorting(Sort sort, @Nullable String alias) {
        String queryString = this.query.getQueryString();
        Assert.hasText((String)queryString, (String)"Query must not be null or empty");
        if (this.parsedType != ParsedType.SELECT || sort.isUnsorted()) {
            return queryString;
        }
        return this.applySorting((Select)JSqlParserQueryEnhancer.deserialize(this.serialized), sort, alias);
    }

    /*
     * WARNING - void declaration
     */
    private String applySorting(Select selectStatement, Sort sort, @Nullable String alias) {
        void selectBody;
        if (selectStatement instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectStatement;
            return JSqlParserQueryEnhancer.applySortingToSetOperationList(setOperationList, sort);
        }
        if (!(selectStatement instanceof PlainSelect)) {
            return selectStatement.toString();
        }
        PlainSelect plainSelect = (PlainSelect)selectStatement;
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>(16);
        for (Sort.Order order : sort) {
            orderByElements.add(JSqlParserQueryEnhancer.getOrderClause(this.joinAliases, this.selectAliases, alias, order));
        }
        if (CollectionUtils.isEmpty((Collection)selectBody.getOrderByElements())) {
            selectBody.setOrderByElements(orderByElements);
        } else {
            selectBody.getOrderByElements().addAll(orderByElements);
        }
        return selectStatement.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        void selectBody;
        if (this.parsedType != ParsedType.SELECT) {
            return this.query.getQueryString();
        }
        Assert.hasText((String)this.query.getQueryString(), (String)"OriginalQuery must not be null or empty");
        Statement statement = (Statement)JSqlParserQueryEnhancer.deserialize(this.serialized);
        if (!(statement instanceof PlainSelect)) {
            return this.query.getQueryString();
        }
        PlainSelect plainSelect = (PlainSelect)statement;
        return JSqlParserQueryEnhancer.createCountQueryFor(this.query, (PlainSelect)selectBody, countProjection, this.primaryAlias);
    }

    private static String createCountQueryFor(DeclaredQuery query, PlainSelect selectBody, @Nullable String countProjection, @Nullable String primaryAlias) {
        selectBody.setOrderByElements(null);
        if (StringUtils.hasText((String)countProjection)) {
            selectBody.setSelectItems(Collections.singletonList(SelectItem.from((Expression)JSqlParserUtils.getJSqlCount(Collections.singletonList(countProjection), false))));
        } else {
            boolean distinct = selectBody.getDistinct() != null;
            selectBody.setDistinct(null);
            Function jSqlCount = JSqlParserUtils.getJSqlCount(Collections.singletonList(JSqlParserQueryEnhancer.countPropertyNameForSelection(selectBody.getSelectItems(), distinct, primaryAlias)), distinct);
            selectBody.setSelectItems(Collections.singletonList(SelectItem.from((Expression)jSqlCount)));
        }
        return selectBody.toString();
    }

    private static String applySortingToSetOperationList(SetOperationList setOperationListStatement, Sort sort) {
        for (Select select : setOperationListStatement.getSelects()) {
            if (!(select instanceof Values)) continue;
            return setOperationListStatement.toString();
        }
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>(16);
        for (Sort.Order order : sort) {
            orderByElements.add(JSqlParserQueryEnhancer.getOrderClause(Collections.emptySet(), Collections.emptySet(), null, order));
        }
        if (setOperationListStatement.getOrderByElements() == null) {
            setOperationListStatement.setOrderByElements(orderByElements);
        } else {
            setOperationListStatement.getOrderByElements().addAll(orderByElements);
        }
        return setOperationListStatement.toString();
    }

    private static OrderByElement getOrderClause(Set<String> joinAliases, Set<String> selectionAliases, @Nullable String alias, Sort.Order order) {
        OrderByElement orderByElement = new OrderByElement();
        orderByElement.setAsc(order.getDirection().isAscending());
        orderByElement.setAscDescPresent(true);
        String property = order.getProperty();
        QueryUtils.checkSortExpression(order);
        if (selectionAliases.contains(property)) {
            Function orderExpression = order.isIgnoreCase() ? JSqlParserUtils.getJSqlLower(property) : new Column(property);
            orderByElement.setExpression((Expression)orderExpression);
            return orderByElement;
        }
        boolean qualifyReference = true;
        for (String joinAlias : joinAliases) {
            if (!property.startsWith(joinAlias.concat("."))) continue;
            qualifyReference = false;
            break;
        }
        boolean functionIndicator = property.contains("(");
        String reference = qualifyReference && !functionIndicator && StringUtils.hasText((String)alias) ? alias + "." + property : property;
        Function orderExpression = order.isIgnoreCase() ? JSqlParserUtils.getJSqlLower(reference) : new Column(reference);
        orderByElement.setExpression((Expression)orderExpression);
        return orderByElement;
    }

    private static String countPropertyNameForSelection(List<SelectItem<?>> selectItems, boolean distinct, @Nullable String tableAlias) {
        if (JSqlParserQueryEnhancer.onlyASingleColumnProjection(selectItems)) {
            SelectItem<?> singleProjection = selectItems.get(0);
            Column column = (Column)singleProjection.getExpression();
            return column.getFullyQualifiedName();
        }
        return distinct ? (String)(tableAlias != null ? tableAlias + "." : "") + "*" : "1";
    }

    private static boolean onlyASingleColumnProjection(List<SelectItem<?>> projection) {
        return projection.size() == 1 && projection.get(0) instanceof SelectItem && projection.get(0).getExpression() instanceof Column;
    }

    private static Object deserialize(byte[] bytes) {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                return ois.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to deserialize object", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to deserialize object type", ex);
        }
    }

    static enum ParsedType {
        DELETE,
        UPDATE,
        SELECT,
        INSERT,
        MERGE,
        OTHER;

    }
}

