/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.factory.internal;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.id.enhanced.LegacyNamingStrategy;
import org.hibernate.id.enhanced.SingleNamingStrategy;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;

public class IdentifierGeneratorUtil {
    public static Generator createLegacyIdentifierGenerator(final SimpleValue simpleValue, IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, final RootClass rootClass) {
        return identifierGeneratorFactory.createIdentifierGenerator(simpleValue.getIdentifierGeneratorStrategy(), simpleValue.getType(), new GeneratorCreationContext(){

            @Override
            public Database getDatabase() {
                return simpleValue.getMetadata().getDatabase();
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return simpleValue.getServiceRegistry();
            }

            @Override
            public String getDefaultCatalog() {
                return null;
            }

            @Override
            public String getDefaultSchema() {
                return null;
            }

            @Override
            public PersistentClass getPersistentClass() {
                return rootClass;
            }

            @Override
            public Property getProperty() {
                return rootClass.getIdentifierProperty();
            }
        }, IdentifierGeneratorUtil.collectParameters(simpleValue, dialect, defaultCatalog, defaultSchema, rootClass));
    }

    public static Properties collectParameters(SimpleValue simpleValue, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) {
        ConfigurationService configService = simpleValue.getServiceRegistry().requireService(ConfigurationService.class);
        Properties params = new Properties();
        if (defaultSchema != null) {
            params.setProperty("schema", defaultSchema);
        }
        if (defaultCatalog != null) {
            params.setProperty("catalog", defaultCatalog);
        }
        params.setProperty("initial_value", String.valueOf(1));
        params.setProperty("increment_size", String.valueOf(IdentifierGeneratorUtil.defaultIncrement(configService)));
        String tableName = simpleValue.getTable().getQuotedName(dialect);
        params.setProperty("target_table", tableName);
        Column column = (Column)simpleValue.getSelectables().get(0);
        String columnName = column.getQuotedName(dialect);
        params.setProperty("target_column", columnName);
        if (rootClass != null) {
            params.setProperty("entity_name", rootClass.getEntityName());
            params.setProperty("jpa_entity_name", rootClass.getJpaEntityName());
            params.setProperty("implicit_name_base", simpleValue.getTable().isSubselect() ? rootClass.getJpaEntityName() : simpleValue.getTable().getName());
            params.setProperty("identity_tables", IdentifierGeneratorUtil.identityTablesString(dialect, rootClass));
        } else {
            params.setProperty("identity_tables", tableName);
            params.setProperty("implicit_name_base", tableName);
        }
        if (simpleValue.getIdentifierGeneratorParameters() != null) {
            params.putAll(simpleValue.getIdentifierGeneratorParameters());
        }
        params.put("CONTRIBUTOR", simpleValue.getBuildingContext().getCurrentContributorName());
        Map<String, Object> settings = configService.getSettings();
        if (settings.containsKey("hibernate.id.optimizer.pooled.preferred")) {
            params.put("hibernate.id.optimizer.pooled.preferred", settings.get("hibernate.id.optimizer.pooled.preferred"));
        }
        return params;
    }

    private static String identityTablesString(Dialect dialect, RootClass rootClass) {
        StringBuilder tables = new StringBuilder();
        for (Table table : rootClass.getIdentityTables()) {
            tables.append(table.getQuotedName(dialect));
            if (tables.length() <= 0) continue;
            tables.append(", ");
        }
        return tables.toString();
    }

    private static int defaultIncrement(ConfigurationService configService) {
        String idNamingStrategy = configService.getSetting("hibernate.id.db_structure_naming_strategy", StandardConverters.STRING, null);
        if ("legacy".equals(idNamingStrategy) || LegacyNamingStrategy.class.getName().equals(idNamingStrategy) || "single".equals(idNamingStrategy) || SingleNamingStrategy.class.getName().equals(idNamingStrategy)) {
            return 1;
        }
        return 50;
    }
}

