/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Collection;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsCache;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class TimestampsCacheEnabledImpl
implements TimestampsCache {
    private static final Logger log = Logger.getLogger(TimestampsCacheEnabledImpl.class);
    public static final boolean DEBUG_ENABLED = log.isDebugEnabled();
    private final TimestampsRegion timestampsRegion;

    public TimestampsCacheEnabledImpl(TimestampsRegion timestampsRegion) {
        this.timestampsRegion = timestampsRegion;
    }

    @Override
    public TimestampsRegion getRegion() {
        return this.timestampsRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInvalidate(String[] spaces, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        RegionFactory regionFactory = factory.getCache().getRegionFactory();
        StatisticsImplementor statistics = factory.getStatistics();
        boolean stats = statistics.isStatisticsEnabled();
        Long ts = regionFactory.nextTimestamp() + regionFactory.getTimeout();
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        boolean debugEnabled = log.isDebugEnabled();
        for (String space : spaces) {
            if (debugEnabled) {
                log.debugf("Pre-invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
            }
            EventManager eventManager = session.getEventManager();
            HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
            try {
                eventListenerManager.cachePutStart();
                this.timestampsRegion.putIntoCache(space, ts, session);
            }
            finally {
                eventManager.completeCachePutEvent(cachePutEvent, session, this.timestampsRegion, true, EventManager.CacheActionDescription.TIMESTAMP_PRE_INVALIDATE);
                eventListenerManager.cachePutEnd();
            }
            if (!stats) continue;
            statistics.updateTimestampsCachePut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(String[] spaces, SharedSessionContractImplementor session) {
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        boolean stats = statistics.isStatisticsEnabled();
        Long ts = session.getFactory().getCache().getRegionFactory().nextTimestamp();
        boolean debugEnabled = log.isDebugEnabled();
        for (String space : spaces) {
            if (debugEnabled) {
                log.debugf("Invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
            }
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            EventManager eventManager = session.getEventManager();
            HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
            try {
                eventListenerManager.cachePutStart();
                this.timestampsRegion.putIntoCache(space, ts, session);
            }
            finally {
                eventManager.completeCachePutEvent(cachePutEvent, session, this.timestampsRegion, true, EventManager.CacheActionDescription.TIMESTAMP_INVALIDATE);
                eventListenerManager.cachePutEnd();
                if (stats) {
                    statistics.updateTimestampsCachePut();
                }
            }
        }
    }

    @Override
    public boolean isUpToDate(String[] spaces, Long timestamp, SharedSessionContractImplementor session) {
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        for (String space : spaces) {
            if (!this.isSpaceOutOfDate(space, timestamp, session, statistics)) continue;
            return false;
        }
        return true;
    }

    private boolean isSpaceOutOfDate(String space, Long timestamp, SharedSessionContractImplementor session, StatisticsImplementor statistics) {
        Long lastUpdate = this.getLastUpdateTimestampForSpace(space, session);
        if (lastUpdate == null) {
            if (statistics.isStatisticsEnabled()) {
                statistics.updateTimestampsCacheMiss();
            }
        } else {
            if (DEBUG_ENABLED) {
                log.debugf("[%s] last update timestamp: %s", (Object)space, (Object)(lastUpdate + ", result set timestamp: " + timestamp));
            }
            if (statistics.isStatisticsEnabled()) {
                statistics.updateTimestampsCacheHit();
            }
            if (lastUpdate >= timestamp) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUpToDate(Collection<String> spaces, Long timestamp, SharedSessionContractImplementor session) {
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        for (String space : spaces) {
            if (!this.isSpaceOutOfDate(space, timestamp, session, statistics)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getLastUpdateTimestampForSpace(String space, SharedSessionContractImplementor session) {
        Long ts = null;
        EventManager eventManager = session.getEventManager();
        HibernateMonitoringEvent cacheGetEvent = eventManager.beginCacheGetEvent();
        try {
            session.getEventListenerManager().cacheGetStart();
            ts = (Long)this.timestampsRegion.getFromCache(space, session);
            eventManager.completeCacheGetEvent(cacheGetEvent, session, this.timestampsRegion, ts != null);
            session.getEventListenerManager().cacheGetEnd(ts != null);
        }
        catch (Throwable throwable) {
            eventManager.completeCacheGetEvent(cacheGetEvent, session, this.timestampsRegion, ts != null);
            session.getEventListenerManager().cacheGetEnd(ts != null);
            throw throwable;
        }
        return ts;
    }
}

