/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public class RealHashTableStatistics
extends RealNoPutResultSetStatistics {
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String nextQualifiers;
    public FormatableProperties scanProperties;
    public ResultSetStatistics childResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RealHashTableStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, int n5, int[] nArray, String string, Properties properties, double d, double d2, ResultSetStatistics[] resultSetStatisticsArray, ResultSetStatistics resultSetStatistics) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.hashtableSize = n5;
        this.hashKeyColumns = ArrayUtil.copy(nArray);
        this.nextQualifiers = string;
        this.scanProperties = new FormatableProperties();
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                this.scanProperties.put(string2, properties.get(string2));
            }
        }
        this.subqueryTrackingArray = ArrayUtil.copy(resultSetStatisticsArray);
        this.childResultSetStatistics = resultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int n) {
        String string;
        int n2;
        Object object = "";
        this.initFormatInfo(n);
        if (this.subqueryTrackingArray != null) {
            boolean bl = false;
            for (n2 = 0; n2 < this.subqueryTrackingArray.length; ++n2) {
                if (this.subqueryTrackingArray[n2] == null) continue;
                if (!bl) {
                    object = this.indent + MessageService.getTextMessage("43X56.U", new Object[0]) + ":\n";
                    bl = true;
                }
                object = (String)object + this.subqueryTrackingArray[n2].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        this.initFormatInfo(n);
        if (this.hashKeyColumns.length == 1) {
            string = MessageService.getTextMessage("43X53.U", new Object[0]) + " " + this.hashKeyColumns[0];
        } else {
            string = MessageService.getTextMessage("43X54.U", new Object[0]) + " (" + this.hashKeyColumns[0];
            for (n2 = 1; n2 < this.hashKeyColumns.length; ++n2) {
                string = string + "," + this.hashKeyColumns[n2];
            }
            string = string + ")";
        }
        return this.indent + MessageService.getTextMessage("43X57.U", new Object[0]) + " (" + this.resultSetNumber + "):\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U", new Object[0]) + " = " + this.hashtableSize + "\n" + this.indent + string + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + (String)(this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U", new Object[0]) + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U", new Object[0]) + ":\n" + this.nextQualifiers + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth);
    }

    @Override
    public String getScanStatisticsText(String string, int n) {
        if (string == null) {
            return this.getStatementExecutionPlanText(n);
        }
        return null;
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeOn() {
        return "";
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X58.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.childResultSetStatistics != null) {
            ++n;
        }
        if (this.subqueryTrackingArray != null) {
            n += this.subqueryTrackingArray.length;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(xPLAINVisitor);
        }
        if (this.subqueryTrackingArray != null) {
            boolean bl = false;
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                this.subqueryTrackingArray[i].accept(xPLAINVisitor);
            }
        }
    }

    @Override
    public String getRSXplainType() {
        return "HASHTABLE";
    }

    @Override
    public String getRSXplainDetails() {
        return "(" + this.resultSetNumber + ")";
    }

    @Override
    public Object getScanPropsDescriptor(Object object) {
        FormatableProperties formatableProperties = this.scanProperties;
        String string = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        String string2 = XPLAINUtil.getHashKeyColumnNumberString(this.hashKeyColumns);
        XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor = new XPLAINScanPropsDescriptor((UUID)object, "Temporary HashTable", null, null, string, null, null, null, null, null, null, null, null, null, null, null, this.nextQualifiers, string2, this.hashtableSize);
        return XPLAINUtil.extractScanProps(xPLAINScanPropsDescriptor, formatableProperties);
    }
}

