/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DeploymentsStateBreakdownReport {
    private final TaskArchive taskArchive;

    public DeploymentsStateBreakdownReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(FilterType filterType, List<ConfigurationItemId> filterCriteria) {
        return DeploymentsStateBreakdownReport.generateReportData(this.fetchReportData(filterType, filterCriteria));
    }

    private Map<String, Integer> fetchReportData(FilterType filterType, List<ConfigurationItemId> filterCriteria) {
        switch (filterType) {
            case APPLICATION: {
                return this.taskArchive.countSuccessfulDeploymentsOfApplications(DeploymentsStateBreakdownReport.getIds(filterCriteria));
            }
            case ENVIRONMENT: {
                return this.taskArchive.countSuccessfulDeploymentsOnEnvironments(DeploymentsStateBreakdownReport.getIds(filterCriteria));
            }
        }
        throw new UnsupportedOperationException("Report filter type, " + String.valueOf(filterType) + " is not supported");
    }

    private static List<String> getIds(List<ConfigurationItemId> filterCriteria) {
        return filterCriteria.stream().map(ConfigurationItemId::getId).collect(Collectors.toList());
    }

    private static Report generateReportData(Map<String, Integer> tasks) {
        return Report.fromLines(tasks.entrySet().stream().map(e -> DeploymentsStateBreakdownReport.generateReportLine((String)e.getKey(), (Integer)e.getValue())));
    }

    private static ReportLine generateReportLine(String entity, Integer count) {
        ReportLine reportLine = new ReportLine();
        reportLine.addValue("entityName", (Object)entity);
        reportLine.addValue("Id", (Object)entity);
        reportLine.addValue("IdWithoutRoot", (Object)entity.substring(entity.indexOf(47) + 1));
        reportLine.addValue("noOfSuccessfulDeployments", (Object)count.toString());
        return reportLine;
    }
}

