/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.bootstrap.encrypt.AbstractEnvironmentDecrypt;
import org.springframework.cloud.bootstrap.encrypt.TextEncryptorUtils;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.ClassUtils;

public class DecryptEnvironmentPostProcessor
extends AbstractEnvironmentDecrypt
implements EnvironmentPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (PropertyUtils.bootstrapEnabled((Environment)environment) || PropertyUtils.useLegacyProcessing((Environment)environment) || !this.isEnabled(environment).booleanValue()) {
            return;
        }
        if (!ClassUtils.isPresent((String)"org.springframework.security.crypto.encrypt.TextEncryptor", null)) {
            return;
        }
        MutablePropertySources propertySources = environment.getPropertySources();
        environment.getPropertySources().remove("decrypted");
        Map<String, Object> map = TextEncryptorUtils.decrypt(this, environment, propertySources);
        if (!map.isEmpty()) {
            propertySources.addFirst((PropertySource)new SystemEnvironmentPropertySource("decrypted", map));
        }
    }

    protected Boolean isEnabled(ConfigurableEnvironment environment) {
        return (Boolean)environment.getProperty("spring.cloud.decrypt-environment-post-processor.enabled", Boolean.class, (Object)true);
    }
}

