/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.enhanced;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.envers.DateTimeFormatter;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;

@MappedSuperclass
public class SequenceIdRevisionEntity
implements Serializable {
    private static final long serialVersionUID = 4159156677698841902L;
    @Id
    @GeneratedValue(generator="RevisionNumberSequenceGenerator")
    @GenericGenerator(name="RevisionNumberSequenceGenerator", strategy="org.hibernate.envers.enhanced.OrderedSequenceGenerator", parameters={@Parameter(name="table_name", value="REVISION_GENERATOR"), @Parameter(name="sequence_name", value="REVISION_GENERATOR"), @Parameter(name="initial_value", value="1"), @Parameter(name="increment_size", value="1")})
    @RevisionNumber
    private int id;
    @RevisionTimestamp
    private long timestamp;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Transient
    public Date getRevisionDate() {
        return new Date(this.timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SequenceIdRevisionEntity)) {
            return false;
        }
        SequenceIdRevisionEntity that = (SequenceIdRevisionEntity)o;
        return this.id == that.id && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "SequenceIdRevisionEntity(id = " + this.id + ", revisionDate = " + DateTimeFormatter.INSTANCE.format(this.getRevisionDate()) + ")";
    }
}

