/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v1.impl;

import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesAndPrincipalsRequest;
import ai.digital.deploy.permissions.api.rest.dto.CheckPermissionWithReferencesRequest;
import ai.digital.deploy.permissions.api.rest.dto.ReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@RestController
@RequestMapping(value={"/v1/permissions/all"})
@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\u0007\u000e\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003<\u0001\u0011\u0005q\r\u0003\u0004<\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\ti\u0003\u0001C\u0001\u0003\u0013Bq!!\f\u0001\t\u0003\tY\u0006C\u0004\u0002.\u0001!\t!a\u001d\u0003)A+'/\\5tg&|gnQ8oiJ|G\u000e\\3s\u0015\tqq\"\u0001\u0003j[Bd'B\u0001\t\u0012\u0003\t1\u0018G\u0003\u0002\u0013'\u0005!!/Z:u\u0015\t!R#A\u0002ba&T!AF\f\u0002\u0017A,'/\\5tg&|gn\u001d\u0006\u00031e\ta\u0001Z3qY>L(B\u0001\u000e\u001c\u0003\u001d!\u0017nZ5uC2T\u0011\u0001H\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\f1B]8mKN+'O^5dKB\u0011qEK\u0007\u0002Q)\u0011\u0011&F\u0001\bg\u0016\u0014h/[2f\u0013\tY\u0003FA\u0006S_2,7+\u001a:wS\u000e,\u0017a\u0007:fM\u0016\u0014XM\\2fIB+'/\\5tg&|gnU3sm&\u001cW\r\u0005\u0002(]%\u0011q\u0006\u000b\u0002\u001c%\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u0002/\u001ddwNY1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007CA\u00143\u0013\t\u0019\u0004FA\fHY>\u0014\u0017\r\u001c)fe6L7o]5p]N+'O^5dK\u00061A(\u001b8jiz\"BA\u000e\u001d:uA\u0011q\u0007A\u0007\u0002\u001b!)Q\u0005\u0002a\u0001M!)A\u0006\u0002a\u0001[!)\u0001\u0007\u0002a\u0001c\u0005!!/Z1e)\ti4\t\u0005\u0002?\u00036\tqH\u0003\u0002A#\u0005\u0019A\r^8\n\u0005\t{$A\u0006*pY\u0016<\u0016\u000e\u001e5QKJl\u0017n]:j_:\u001cH\t^8\t\u000b\u0011+\u0001\u0019A#\u0002\u0011I|G.\u001a(b[\u0016\u0004\"AR'\u000f\u0005\u001d[\u0005C\u0001%\"\u001b\u0005I%B\u0001&\u001e\u0003\u0019a$o\\8u}%\u0011A*I\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002MC!\u00121)\u0015\t\u0003%vk\u0011a\u0015\u0006\u0003)V\u000b!\"\u00198o_R\fG/[8o\u0015\t1v+\u0001\u0003cS:$'B\u0001-Z\u0003\r9XM\u0019\u0006\u00035n\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u00029\u0006\u0019qN]4\n\u0005y\u001b&\u0001\u0004)bi\"4\u0016M]5bE2,\u0007\u0006B\u0003aG\u0012\u0004\"AU1\n\u0005\t\u001c&AC$fi6\u000b\u0007\u000f]5oO\u0006)a/\u00197vK2\nQ-I\u0001g\u0003-y3P]8mK:\u000bW.Z?\u0015\u0005!\f\bcA5o{9\u0011!\u000e\u001c\b\u0003\u0011.L\u0011AI\u0005\u0003[\u0006\nq\u0001]1dW\u0006<W-\u0003\u0002pa\n!A*[:u\u0015\ti\u0017\u0005C\u0003s\r\u0001\u00071/A\u0005s_2,g*Y7fgB\u0019A/_#\u000e\u0003UT!A^<\u0002\tU$\u0018\u000e\u001c\u0006\u0002q\u0006!!.\u0019<b\u0013\tyW\u000f\u000b\u0002rwB\u0011!\u000b`\u0005\u0003{N\u0013ABU3rk\u0016\u001cH\u000fU1sC6DCA\u00021d\u007f2\u0012\u0011\u0011A\u0011\u0003\u0003\u0007\taa\f:pY\u0016\u001cHCBA\u0004\u0003/\tY\u0002E\u0003\u0002\n\u0005MQ(\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0019!w.\\1j]*\u0019\u0011\u0011C-\u0002\t\u0011\fG/Y\u0005\u0005\u0003+\tYA\u0001\u0003QC\u001e,\u0007\"\u0002:\b\u0001\u0004\u0019\bfAA\fw\"9\u0011QD\u0004A\u0002\u0005}\u0011\u0001\u00039bO\u0016\f'\r\\3\u0011\t\u0005%\u0011\u0011E\u0005\u0005\u0003G\tYA\u0001\u0005QC\u001e,\u0017M\u00197fQ\u00159\u0001mYA\u0014Y\t\tI#\t\u0002\u0002,\u0005iqF]8mKN|c-\u001b7uKJ\fqb\u00195fG.\u0004VM]7jgNLwN\u001c\u000b\u0005\u0003c\t9\u0004E\u0002!\u0003gI1!!\u000e\"\u0005\u001d\u0011un\u001c7fC:Dq!!\u000f\t\u0001\u0004\tY$\u0001\fdQ\u0016\u001c7\u000eU3s[&\u001c8/[8o%\u0016\fX/Z:u!\rq\u0014QH\u0005\u0004\u0003\u007fy$AF\"iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8SKF,Xm\u001d;)\u000b!\u00017-a\u0011-\u0005\u0005\u0015\u0013EAA$\u0003\u0019y3\r[3dWR!\u0011\u0011GA&\u0011\u001d\tI$\u0003a\u0001\u0003\u001b\u00022APA(\u0013\r\t\tf\u0010\u0002%\u0007\",7m\u001b)fe6L7o]5p]^KG\u000f\u001b)sS:\u001c\u0017\u000e]1mgJ+\u0017/^3ti\"*\u0011\u0002Y2\u0002V1\u0012\u0011qK\u0011\u0003\u00033\n\u0011cL2iK\u000e\\w\u0006\u001d:j]\u000eL\u0007/\u00197t)\u0011\ti&a\u0019\u0011\r\u0019\u000by&RA\u0019\u0013\r\t\tg\u0014\u0002\u0004\u001b\u0006\u0004\bbBA\u001d\u0015\u0001\u0007\u0011Q\r\t\u0004}\u0005\u001d\u0014bAA5\u007f\t!3\t[3dWB+'/\\5tg&|gnV5uQJ+g-\u001a:f]\u000e,7OU3rk\u0016\u001cH\u000fK\u0003\u000bA\u000e\fi\u0007\f\u0002\u0002p\u0005\u0012\u0011\u0011O\u0001\u0012_I,g-\u001a:f]\u000e,7oL2iK\u000e\\G\u0003BA/\u0003kBq!!\u000f\f\u0001\u0004\t9\bE\u0002?\u0003sJ1!a\u001f@\u0005E\u001a\u0005.Z2l!\u0016\u0014X.[:tS>tw+\u001b;i%\u00164WM]3oG\u0016\u001c\u0018I\u001c3Qe&t7-\u001b9bYN\u0014V-];fgRDSa\u00031d\u0003\u007fb#!!!\"\u0005\u0005\r\u0015\u0001H\u0018sK\u001a,'/\u001a8dKN|3\r[3dW>\u0002(/\u001b8dSB\fGn\u001d\u0015\u0004\u0001\u0005\u001d\u0005c\u0001*\u0002\n&\u0019\u00111R*\u0003\u001dI+7\u000f^\"p]R\u0014x\u000e\u001c7fe\"2\u0001!a$d\u0003+\u00032AUAI\u0013\r\t\u0019j\u0015\u0002\u000f%\u0016\fX/Z:u\u001b\u0006\u0004\b/\u001b8hY\t\t9*\t\u0002\u0002\u001a\u0006\u0019rF^\u00190a\u0016\u0014X.[:tS>t7oL1mY\u0002")
public class PermissionController {
    private final RoleService roleService;
    private final ReferencedPermissionService referencedPermissionService;
    private final GlobalPermissionService globalPermissionService;

    @GetMapping(value={"/{roleName}"})
    public RoleWithPermissionsDto read(@PathVariable String roleName) {
        List globalPermissions = this.globalPermissionService.read(roleName).map((Function1 & Serializable)x$1 -> x$1.permissionName());
        Either either = this.referencedPermissionService.read(roleName);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List result = (List)right.value();
        Map referencedPermissions = result.groupBy((Function1 & Serializable)x$2 -> x$2.reference());
        Role role = (Role)this.roleService.read(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(roleName);
        });
        List referencedPermissionsDto = ((IterableOnceOps)referencedPermissions.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$3 -> x$3.permissionName())))).toList();
        return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), globalPermissions, referencedPermissionsDto);
    }

    @GetMapping(value={"/roles"})
    public List<RoleWithPermissionsDto> read(@RequestParam java.util.List<String> roleNames) {
        Map globalPermissions = this.globalPermissionService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList()).groupBy((Function1 & Serializable)x$4 -> x$4.role().name());
        Either either = this.referencedPermissionService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList());
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List result = (List)right.value();
        Map referencedPermissions = result.groupBy((Function1 & Serializable)x$5 -> x$5.role().name());
        Either either2 = this.roleService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList());
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either2 instanceof Right) {
            Right right2 = (Right)either2;
            List roles = (List)right2.value();
            return roles.map((Function1 & Serializable)role -> {
                Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$6 -> x$6.reference());
                List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$7 -> x$7.permissionName())))).toList();
                return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
            });
        }
        throw new MatchError((Object)either2);
    }

    @GetMapping(value={"/roles/filter"})
    public Page<RoleWithPermissionsDto> read(@RequestParam java.util.List<String> roleNames, Pageable pageable) {
        Page roles = this.roleService.read(CollectionConverters$.MODULE$.ListHasAsScala(roleNames).asScala().toList(), pageable);
        List names = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)x$8 -> x$8.name());
        Map globalPermissions = this.globalPermissionService.read(names).groupBy((Function1 & Serializable)x$9 -> x$9.role().name());
        Either either = this.referencedPermissionService.read(names);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List result = (List)right.value();
        Map referencedPermissions = result.groupBy((Function1 & Serializable)x$10 -> x$10.role().name());
        List dtos = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)roles).asScala().toList().map((Function1 & Serializable)role -> {
            Map referencedPermissionsForRole = ((IterableOps)referencedPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())).groupBy((Function1 & Serializable)x$11 -> x$11.reference());
            List referencedPermissionsDto = ((IterableOnceOps)referencedPermissionsForRole.map((Function1 & Serializable)rp -> new ReferencedPermissionsDto((UUID)rp._1(), ((List)rp._2()).map((Function1 & Serializable)x$12 -> x$12.permissionName())))).toList();
            return new RoleWithPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), RoleWithGlobalPermissionsConverter$.MODULE$.globalPermissionToDto((List)globalPermissions.getOrElse((Object)role.name(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), referencedPermissionsDto);
        });
        return new PageImpl(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dtos).asJava(), pageable, roles.getTotalElements());
    }

    @GetMapping(value={"/check"})
    public boolean checkPermission(CheckPermissionRequest checkPermissionRequest) {
        Option referenceMaybe = Option$.MODULE$.apply((Object)checkPermissionRequest.referenceMaybe());
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList())));
    }

    @GetMapping(value={"/check/principals"})
    public boolean checkPermission(CheckPermissionWithPrincipalsRequest checkPermissionRequest) {
        Option referenceMaybe = Option$.MODULE$.apply((Object)checkPermissionRequest.referenceMaybe());
        return BoxesRunTime.unboxToBoolean((Object)referenceMaybe.map((Function1 & Serializable)referenceId -> BoxesRunTime.boxToBoolean((boolean)this.referencedPermissionService.checkPermission(referenceId, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList())));
    }

    @GetMapping(value={"/references/check"})
    public Map<String, Object> checkPermission(CheckPermissionWithReferencesRequest checkPermissionRequest) {
        if (CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().isEmpty()) {
            return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList())))}));
        }
        return CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @GetMapping(value={"/references/check/principals"})
    public Map<String, Object> checkPermission(CheckPermissionWithReferencesAndPrincipalsRequest checkPermissionRequest) {
        if (CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().isEmpty()) {
            return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"global"), (Object)BoxesRunTime.boxToBoolean((boolean)this.globalPermissionService.checkPermission(CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList())))}));
        }
        return CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.references()).asScala().toList().map((Function1 & Serializable)reference -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reference.toString()), (Object)BoxesRunTime.boxToBoolean((boolean)$this.referencedPermissionService.checkPermission(reference, CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.permissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.allRoles()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(checkPermissionRequest.principals()).asScala().toList())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public PermissionController(RoleService roleService, ReferencedPermissionService referencedPermissionService, GlobalPermissionService globalPermissionService) {
        this.roleService = roleService;
        this.referencedPermissionService = referencedPermissionService;
        this.globalPermissionService = globalPermissionService;
    }
}

