/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.environment.MongoDbEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MongoDbEnvironmentRepository;
import org.springframework.cloud.config.server.environment.MongoDbEnvironmentRepositoryFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(proxyBeanMethods=false)
@Profile(value={"mongodb"})
@ConditionalOnClass(value={MongoTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.config.server.mongodb.enabled"}, matchIfMissing=true)
class MongoRepositoryConfiguration {
    MongoRepositoryConfiguration() {
    }

    @Bean
    @ConditionalOnBean(value={MongoTemplate.class})
    public MongoDbEnvironmentRepository mongoDbEnvironmentRepository(MongoDbEnvironmentRepositoryFactory factory, MongoDbEnvironmentProperties environmentProperties) {
        return factory.build(environmentProperties);
    }
}

