/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.util;

import ai.digital.deploy.settings.GeneralSettings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.util.GeneralSettingsUtils$Duration$;
import java.io.Serializable;
import java.util.Base64;
import org.apache.tika.Tika;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class GeneralSettingsUtils$ {
    public static final GeneralSettingsUtils$ MODULE$ = new GeneralSettingsUtils$();
    private static final int MAX_LOGO_FILE_SIZE_BYTES = 0x100000;
    private static final int MAX_INSTANCE_NAME_SIZE = 150;
    private static final Tika tika = new Tika();
    private static final String base64 = "base64,";

    private int MAX_LOGO_FILE_SIZE_BYTES() {
        return MAX_LOGO_FILE_SIZE_BYTES;
    }

    private int MAX_INSTANCE_NAME_SIZE() {
        return MAX_INSTANCE_NAME_SIZE;
    }

    private Tika tika() {
        return tika;
    }

    private String base64() {
        return base64;
    }

    public void validate(GeneralSettings generalSetting) {
        this.validateInstanceNameLength(generalSetting.instanceName());
        this.validateLogoFile(generalSetting.logoFile());
        this.validateDurationValue(generalSetting.patExpirationDuration());
        this.validatePatNotificationConfig(generalSetting.patEmailNotificationEnabled(), generalSetting.patEmailNotificationTriggerPeriod(), generalSetting.patEmailNotificationSMTPServerCiRef());
    }

    private void validateInstanceNameLength(String instanceName) {
        if (instanceName != null) {
            Checks.checkTrue((instanceName.length() <= this.MAX_INSTANCE_NAME_SIZE() ? 1 : 0) != 0, (String)("Instance name length should be maximum " + this.MAX_INSTANCE_NAME_SIZE() + " characters."), (Object[])new Object[0]);
            return;
        }
    }

    private void validateLogoFile(String logoFile) {
        if (logoFile != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(logoFile))) {
            this.validateLogoFileSize(logoFile);
            this.validateLogoFileType(logoFile);
            this.validateLogoMimeType(logoFile);
            return;
        }
    }

    private void validateLogoFileSize(String logoFile) {
        int paddingCount;
        int characterCount = logoFile.length();
        int sizeInBytes = 3 * (characterCount / 4) - (paddingCount = StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(logoFile.substring(characterCount - 2, characterCount)), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)GeneralSettingsUtils$.$anonfun$validateLogoFileSize$1(BoxesRunTime.unboxToChar((Object)c)))));
        Checks.checkTrue((sizeInBytes <= this.MAX_LOGO_FILE_SIZE_BYTES() ? 1 : 0) != 0, (String)"Logo file is too large. Maximum size is 1 MB", (Object[])new Object[0]);
    }

    private void validateLogoFileType(String logoFile) {
        Checks.checkTrue((boolean)logoFile.substring("data:".length()).startsWith("image/"), (String)"Logo file must be of an image file type.", (Object[])new Object[0]);
    }

    private void validateLogoMimeType(String logoFile) {
        String detectedMimeType = this.getLogoMimeType(logoFile);
        Checks.checkTrue((boolean)detectedMimeType.startsWith("image/"), (String)"Logo file must be of an image file type.", (Object[])new Object[0]);
    }

    public String getLogoMimeType(String logoFile) {
        byte[] decodedBytes = Base64.getDecoder().decode(logoFile.substring(logoFile.indexOf(this.base64()) + this.base64().length()));
        return this.tika().detect(decodedBytes);
    }

    private void validateDurationValue(String duration) {
        if (duration != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(duration)) && (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(duration), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$2))))) || duration.startsWith("-") && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(duration.substring(1)), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3))))))) {
            Option<Enumeration.Value> option = GeneralSettingsUtils$Duration$.MODULE$.fromValue(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(duration)));
            if (option instanceof Some) {
                return;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException("Invalid duration value: " + duration);
            }
            throw new MatchError(option);
        }
        throw new IllegalArgumentException("Duration value must be a valid integer and cannot be null or empty.");
    }

    private void validatePatNotificationConfig(boolean patEmailNotificationEnabled, String patEmailNotificationTriggerPeriod, String patEmailNotificationSMTPServerCiRef) {
        if (patEmailNotificationEnabled) {
            if (patEmailNotificationTriggerPeriod == null || patEmailNotificationTriggerPeriod.isEmpty()) {
                throw new IllegalArgumentException("PAT email notification trigger period must be specified when PAT notifications are enabled.");
            }
            if (patEmailNotificationSMTPServerCiRef == null || patEmailNotificationSMTPServerCiRef.isEmpty()) {
                throw new IllegalArgumentException("PAT email notification SMTP server must be specified when PAT notifications are enabled.");
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateLogoFileSize$1(char c) {
        return c == '=';
    }

    private GeneralSettingsUtils$() {
    }
}

