/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.runnables;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnableWithDelegate;
import org.apache.activemq.artemis.utils.runnables.RunnableList;

public abstract class AtomicRunnable
implements Runnable {
    private RunnableList acceptedList;
    private Consumer<AtomicRunnable> cancelTask;
    private volatile int ran;
    private static final AtomicIntegerFieldUpdater<AtomicRunnable> RAN_UPDATE = AtomicIntegerFieldUpdater.newUpdater(AtomicRunnable.class, "ran");

    public static AtomicRunnable checkAtomic(Runnable run) {
        if (run instanceof AtomicRunnable) {
            return (AtomicRunnable)run;
        }
        return new AtomicRunnableWithDelegate(run);
    }

    public RunnableList getAcceptedList() {
        return this.acceptedList;
    }

    public AtomicRunnable setAcceptedList(RunnableList acceptedList) {
        this.acceptedList = acceptedList;
        return this;
    }

    public Consumer<AtomicRunnable> getCancel() {
        return this.cancelTask;
    }

    public AtomicRunnable setCancel(Consumer<AtomicRunnable> cancelTask) {
        this.cancelTask = cancelTask;
        return this;
    }

    public AtomicRunnable reset() {
        RAN_UPDATE.set(this, 0);
        return this;
    }

    public AtomicRunnable setRan() {
        RAN_UPDATE.set(this, 1);
        return this;
    }

    public boolean isRun() {
        return RAN_UPDATE.get(this) == 1;
    }

    @Override
    public void run() {
        if (RAN_UPDATE.compareAndSet(this, 0, 1)) {
            try {
                this.atomicRun();
            }
            finally {
                if (this.acceptedList != null) {
                    this.acceptedList.remove(this);
                }
            }
        }
    }

    public void cancel() {
        if (RAN_UPDATE.compareAndSet(this, 0, 1) && this.cancelTask != null) {
            this.cancelTask.accept(this);
        }
    }

    public abstract void atomicRun();
}

