/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.i18n;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.i18n.BundleFinder;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.reference.ModuleUtil;

public final class MessageService {
    private static final Locale EN = new Locale("en", "US");
    private static final String LOCALE_STUB = "locale_";
    private static final String CLIENT_MESSAGES = "clientmessages";
    private static final String TOOLS_MESSAGES = "toolsmessages";
    private static final String SYSINFO_MESSAGES = "sysinfoMessages";
    private static final String SERVER_MESSAGES = "drda";
    private static BundleFinder finder;

    private MessageService() {
    }

    public static ResourceBundle getBundleForLocale(Locale locale, String string) {
        try {
            return MessageService.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageService.hashString50(string), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static void setFinder(BundleFinder bundleFinder) {
        finder = bundleFinder;
    }

    public static String getTextMessage(String string, Object ... objectArray) {
        try {
            return MessageService.formatMessage(MessageService.getBundle(string), string, objectArray, true);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        return MessageService.formatMessage(MessageService.getBundleForLocale(EN, string), string, objectArray, false);
    }

    public static String getProperty(String string, String string2) {
        ResourceBundle resourceBundle = MessageService.getBundle(string);
        try {
            if (resourceBundle != null) {
                return resourceBundle.getString(string.concat(".").concat(string2));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String formatMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, boolean bl) {
        block12: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            if (resourceBundle != null) {
                try {
                    string = resourceBundle.getString(string);
                    try {
                        return MessageFormat.format(string, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!bl) break block12;
                    throw missingResourceException;
                }
            }
        }
        if (string == null) {
            string = "UNKNOWN";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = objectArray.length;
        if (n > 0) {
            stringBuffer.append(" : ");
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(i);
            stringBuffer.append("] ");
            if (objectArray[i] == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    private static ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = null;
        if (finder != null) {
            resourceBundle = finder.getBundle(string);
        }
        if (resourceBundle == null) {
            resourceBundle = MessageService.getBundleForLocale(Locale.getDefault(), string);
        }
        return resourceBundle;
    }

    public static ResourceBundle getBundleWithEnDefault(String string, Locale locale) {
        Locale locale2;
        ResourceBundle resourceBundle = null;
        resourceBundle = MessageService.getBundle(string, locale);
        if (resourceBundle == null && !(locale2 = Locale.getDefault()).equals(locale)) {
            resourceBundle = MessageService.getBundle(string, locale2);
        }
        if (resourceBundle == null) {
            resourceBundle = MessageService.lookupBundle(string, EN);
        }
        return resourceBundle;
    }

    private static ResourceBundle getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = MessageService.lookupBundle(MessageService.localizeResourceName(string, locale.toString()), locale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = MessageService.lookupBundle(MessageService.localizeResourceName(string, locale.getLanguage()), locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return resourceBundle;
    }

    private static ResourceBundle lookupBundle(String string, Locale locale) {
        if (JVMInfo.isModuleAware()) {
            return MessageService.lookupBundleInModule(string, locale);
        }
        return ResourceBundle.getBundle(string, locale);
    }

    public static ResourceBundle lookupBundleInModule(String string, Locale locale) {
        String string2;
        boolean bl = locale.getLanguage().equals(EN.getLanguage());
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.contains(CLIENT_MESSAGES)) {
            string2 = "org.apache.derby.client";
        } else if (string.contains(SERVER_MESSAGES)) {
            string2 = "org.apache.derby.server";
        } else if (string.contains(TOOLS_MESSAGES) || string.contains(SYSINFO_MESSAGES)) {
            if (bl) {
                string2 = "org.apache.derby.tools";
            } else {
                string2 = ModuleUtil.localizationModuleName(locale.toString());
                bl3 = true;
            }
        } else if (bl) {
            string2 = "org.apache.derby.engine";
            bl2 = true;
        } else {
            string2 = ModuleUtil.localizationModuleName(locale.toString());
            bl3 = true;
        }
        Module module = ModuleUtil.derbyModule(string2);
        if (module == null && bl3) {
            string2 = ModuleUtil.localizationModuleName(locale.getLanguage());
            module = ModuleUtil.derbyModule(string2);
        }
        if (module == null) {
            return null;
        }
        ResourceBundle resourceBundle = MessageService.lookupBundleInModule(module, string, locale.toString(), bl, bl2);
        if (resourceBundle == null) {
            resourceBundle = MessageService.lookupBundleInModule(module, string, locale.getLanguage(), bl, bl2);
        }
        return resourceBundle;
    }

    private static ResourceBundle lookupBundleInModule(Module module, String string, String string2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.replace('.', '/'));
        if (!bl) {
            stringBuilder.append("_");
            stringBuilder.append(string2);
        }
        if (bl2 && bl) {
            stringBuilder.append("_en");
        }
        stringBuilder.append(".properties");
        String string3 = stringBuilder.toString();
        return MessageService.getModuleResourceBundle(string3, module);
    }

    private static PropertyResourceBundle getModuleResourceBundle(String string, Module module) {
        try {
            InputStream inputStream = module.getResourceAsStream(string);
            if (inputStream != null) {
                return new PropertyResourceBundle(inputStream);
            }
            return null;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    private static String localizeResourceName(String string, String string2) {
        if (string == null || string.contains(CLIENT_MESSAGES) || string.contains(SERVER_MESSAGES)) {
            return string;
        }
        if (EN.toString().equals(string2)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        String string3 = string.substring(0, n + 1) + LOCALE_STUB + string2 + string.substring(n, string.length());
        return string3;
    }

    public static int hashString50(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 5) {
            n2 = 5;
        }
        for (int i = 0; i < n2; ++i) {
            n += string.charAt(i);
        }
        return n %= 50;
    }
}

