/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;

public interface AvailabilityStrategy {
    public static ConsistentHash ownersConsistentHash(CacheTopology topology, ConsistentHashFactory chFactory) {
        switch (topology.getPhase()) {
            case NO_REBALANCE: {
                return topology.getCurrentCH();
            }
            case TRANSITORY: {
                return topology.getCurrentCH();
            }
            case CONFLICT_RESOLUTION: 
            case READ_OLD_WRITE_ALL: {
                return topology.getCurrentCH();
            }
            case READ_ALL_WRITE_ALL: {
                return chFactory.union(topology.getCurrentCH(), topology.getPendingCH());
            }
            case READ_NEW_WRITE_ALL: {
                return topology.getPendingCH();
            }
        }
        throw new IllegalStateException();
    }

    public void onJoin(AvailabilityStrategyContext var1, Address var2);

    public void onGracefulLeave(AvailabilityStrategyContext var1, Address var2);

    public void onClusterViewChange(AvailabilityStrategyContext var1, List<Address> var2);

    public void onPartitionMerge(AvailabilityStrategyContext var1, Map<Address, CacheStatusResponse> var2);

    public void onRebalanceEnd(AvailabilityStrategyContext var1);

    public void onManualAvailabilityChange(AvailabilityStrategyContext var1, AvailabilityMode var2);
}

