/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.simple.extend;

import com.openhtmltopdf.simple.extend.XhtmlCssOnlyNamespaceHandler;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XhtmlNamespaceHandler
extends XhtmlCssOnlyNamespaceHandler {
    private static final String DEFAULT_SVG_DIMS = "";

    @Override
    public boolean isImageElement(Element e) {
        return e != null && e.getNodeName().equalsIgnoreCase("img");
    }

    @Override
    public boolean isFormElement(Element e) {
        return e != null && e.getNodeName().equalsIgnoreCase("form");
    }

    @Override
    public String getImageSourceURI(Element e) {
        return e != null ? e.getAttribute("src") : null;
    }

    @Override
    public String getNonCssStyling(Element e) {
        switch (e.getNodeName()) {
            case "table": {
                return this.applyTableStyles(e);
            }
            case "td": 
            case "th": {
                return this.applyTableCellStyles(e);
            }
            case "tr": {
                return this.applyTableRowStyles(e);
            }
            case "img": {
                return this.applyImgStyles(e);
            }
            case "p": 
            case "div": {
                return this.applyBlockAlign(e);
            }
            case "textarea": {
                return this.applyTextareaStyles(e);
            }
            case "input": {
                return this.applyInputStyles(e);
            }
            case "svg": {
                return this.applySvgStyles(e);
            }
        }
        return DEFAULT_SVG_DIMS;
    }

    private String applySvgStyles(Element e) {
        String w = e.getAttribute("width");
        String h = e.getAttribute("height");
        if (!w.isEmpty() || !h.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            if (!w.isEmpty()) {
                sb.append("width: ");
                sb.append(w);
                if (this.isInteger(w)) {
                    sb.append("px");
                }
                sb.append(';');
            }
            if (!h.isEmpty()) {
                sb.append("height: ");
                sb.append(h);
                if (this.isInteger(h)) {
                    sb.append("px");
                }
                sb.append(';');
            }
            return sb.toString();
        }
        String viewBoxAttr = e.getAttribute("viewBox");
        String[] splitViewBox = viewBoxAttr.split("\\s+");
        if (splitViewBox.length != 4) {
            return DEFAULT_SVG_DIMS;
        }
        try {
            int viewBoxWidth = Integer.parseInt(splitViewBox[2]);
            int viewBoxHeight = Integer.parseInt(splitViewBox[3]);
            StringBuilder sb = new StringBuilder();
            sb.append("width: ");
            sb.append(viewBoxWidth);
            sb.append("px;");
            sb.append("height: ");
            sb.append(viewBoxHeight);
            sb.append("px;");
        }
        catch (NumberFormatException ex) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.GENERAL_INVALID_INTEGER_PASSED_IN_VIEWBOX_ATTRIBUTE_FOR_SVG, viewBoxAttr);
        }
        return DEFAULT_SVG_DIMS;
    }

    private String applyInputStyles(Element e) {
        StringBuilder sb = new StringBuilder();
        if (e.hasAttribute("width") && this.isInteger(e.getAttribute("width"))) {
            sb.append("width: ");
            sb.append(e.getAttribute("width"));
            sb.append("px;");
        } else if (e.hasAttribute("size") && this.isInteger(e.getAttribute("size"))) {
            sb.append("width: ");
            sb.append(e.getAttribute("size"));
            sb.append("em;");
        }
        return sb.toString();
    }

    private String applyTextareaStyles(Element e) {
        StringBuilder sb = new StringBuilder();
        if (e.hasAttribute("cols") && this.isInteger(e.getAttribute("cols"))) {
            sb.append("width: ");
            sb.append(e.getAttribute("cols"));
            sb.append("em;");
        }
        if (e.hasAttribute("rows") && this.isInteger(e.getAttribute("rows"))) {
            sb.append("height: ");
            sb.append(e.getAttribute("rows"));
            sb.append("em;");
        }
        return sb.toString();
    }

    private String applyBlockAlign(Element e) {
        StringBuilder style = new StringBuilder();
        this.applyTextAlign(e, style);
        return style.toString();
    }

    private String applyImgStyles(Element e) {
        StringBuilder style = new StringBuilder();
        this.applyFloatingAlign(e, style);
        return style.toString();
    }

    private String applyTableCellStyles(Element e) {
        String s;
        StringBuilder style = new StringBuilder();
        Element table = this.findTable(e);
        if (table != null) {
            s = this.getAttribute(table, "cellpadding");
            if (s != null) {
                style.append("padding: ");
                style.append(this.convertToLength(s));
                style.append(";");
            }
            if ((s = this.getAttribute(table, "border")) != null && !s.equals("0")) {
                style.append("border: 1px outset black;");
            }
        }
        if ((s = this.getAttribute(e, "width")) != null) {
            style.append("width: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e, "height")) != null) {
            style.append("height: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        this.applyTableContentAlign(e, style);
        s = this.getAttribute(e, "bgcolor");
        if (s != null) {
            s = s.toLowerCase();
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s)) {
                style.append('#');
                style.append(s);
            } else {
                style.append(s);
            }
            style.append(';');
        }
        if ((s = this.getAttribute(e, "background")) != null) {
            style.append("background-image: url(");
            style.append(s);
            style.append(");");
        }
        return style.toString();
    }

    private String applyTableStyles(Element e) {
        StringBuilder style = new StringBuilder();
        String s = this.getAttribute(e, "width");
        if (s != null) {
            style.append("width: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e, "border")) != null) {
            style.append("border: ");
            style.append(this.convertToLength(s));
            style.append(" inset black;");
        }
        if ((s = this.getAttribute(e, "cellspacing")) != null) {
            style.append("border-collapse: separate; border-spacing: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e, "bgcolor")) != null) {
            s = s.toLowerCase();
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s)) {
                style.append('#');
                style.append(s);
            } else {
                style.append(s);
            }
            style.append(';');
        }
        if ((s = this.getAttribute(e, "background")) != null) {
            style.append("background-image: url(");
            style.append(s);
            style.append(");");
        }
        this.applyFloatingAlign(e, style);
        return style.toString();
    }

    private String applyTableRowStyles(Element e) {
        StringBuilder style = new StringBuilder();
        this.applyTableContentAlign(e, style);
        return style.toString();
    }

    private void applyFloatingAlign(Element e, StringBuilder style) {
        String s = this.getAttribute(e, "align");
        if (s != null) {
            if ((s = s.toLowerCase().trim()).equals("left")) {
                style.append("float: left;");
            } else if (s.equals("right")) {
                style.append("float: right;");
            } else if (s.equals("center")) {
                style.append("margin-left: auto; margin-right: auto;");
            }
        }
    }

    private void applyTextAlign(Element e, StringBuilder style) {
        String s = this.getAttribute(e, "align");
        if (s != null && ((s = s.toLowerCase().trim()).equals("left") || s.equals("right") || s.equals("center") || s.equals("justify"))) {
            style.append("text-align: ");
            style.append(s);
            style.append(";");
        }
    }

    private void applyTableContentAlign(Element e, StringBuilder style) {
        String s = this.getAttribute(e, "align");
        if (s != null) {
            style.append("text-align: ");
            style.append(s.toLowerCase());
            style.append(";");
        }
        if ((s = this.getAttribute(e, "valign")) != null) {
            style.append("vertical-align: ");
            style.append(s.toLowerCase());
            style.append(";");
        }
    }

    private boolean looksLikeAMangledColor(String s) {
        if (s.length() != 6) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            boolean valid;
            char c = s.charAt(i);
            boolean bl = valid = c >= '0' && c <= '9' || c >= 'a' && c <= 'f';
            if (valid) continue;
            return false;
        }
        return true;
    }

    private Element findTable(Element cell) {
        Element next;
        Node n = cell.getParentNode();
        if (n.getNodeType() == 1 && (next = (Element)n).getNodeName().equals("tr") && (n = next.getParentNode()).getNodeType() == 1) {
            next = (Element)n;
            String name = next.getNodeName();
            if (name.equals("table")) {
                return next;
            }
            if ((name.equals("tbody") || name.equals("tfoot") || name.equals("thead")) && (n = next.getParentNode()).getNodeType() == 1 && (next = (Element)n).getNodeName().equals("table")) {
                return next;
            }
        }
        return null;
    }
}

