/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools;

import java.util.Map;

public abstract class ArraysTools {
    public static <T> boolean arrayIncludesInstanceOf(T[] array, Class<?> cls) {
        for (T obj : array) {
            if (!cls.isAssignableFrom(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean arraysEqual(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (!(array1[i] != null ? !array1[i].equals(array2[i]) : array2[i] != null)) continue;
            return false;
        }
        return true;
    }

    public static Object[] mapToArray(Map<String, Object> data, String[] keys) {
        Object[] ret = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ret[i] = data.get(keys[i]);
        }
        return ret;
    }
}

