/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.BlockingLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.BlockingRestClassesPresentCondition;
import org.springframework.cloud.client.loadbalancer.DeferringLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRestClientBuilderBeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRestTemplateBuilderBeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@Conditional(value={BlockingRestClassesPresentCondition.class})
@ConditionalOnBean(value={LoadBalancerClient.class})
@EnableConfigurationProperties(value={LoadBalancerClientsProperties.class})
public class LoadBalancerAutoConfiguration {
    @LoadBalanced
    @Autowired(required=false)
    private List<RestTemplate> restTemplates = Collections.emptyList();
    @Autowired(required=false)
    private List<LoadBalancerRequestTransformer> transformers = Collections.emptyList();

    @Bean
    public SmartInitializingSingleton loadBalancedRestTemplateInitializerDeprecated(ObjectProvider<List<RestTemplateCustomizer>> restTemplateCustomizers) {
        return () -> restTemplateCustomizers.ifAvailable(customizers -> {
            for (RestTemplate restTemplate : this.restTemplates) {
                for (RestTemplateCustomizer customizer : customizers) {
                    customizer.customize(restTemplate);
                }
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public LoadBalancerRequestFactory loadBalancerRequestFactory(LoadBalancerClient loadBalancerClient) {
        return new LoadBalancerRequestFactory(loadBalancerClient, this.transformers);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RetryTemplate.class})
    @ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, matchIfMissing=true)
    public static class RetryInterceptorAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public RetryLoadBalancerInterceptor loadBalancerInterceptor(LoadBalancerClient loadBalancerClient, LoadBalancerRequestFactory requestFactory, LoadBalancedRetryFactory loadBalancedRetryFactory, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
            return new RetryLoadBalancerInterceptor(loadBalancerClient, requestFactory, loadBalancedRetryFactory, loadBalancerFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        public RestTemplateCustomizer restTemplateCustomizer(RetryLoadBalancerInterceptor loadBalancerInterceptor) {
            return restTemplate -> {
                ArrayList<RetryLoadBalancerInterceptor> list = new ArrayList<RetryLoadBalancerInterceptor>(restTemplate.getInterceptors());
                list.add(loadBalancerInterceptor);
                restTemplate.setInterceptors(list);
            };
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={RetryTemplate.class})
    public static class RetryAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public LoadBalancedRetryFactory loadBalancedRetryFactory() {
            return new LoadBalancedRetryFactory(){};
        }
    }

    private static class RetryMissingOrDisabledCondition
    extends AnyNestedCondition {
        RetryMissingOrDisabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="false")
        static class RetryDisabled {
            RetryDisabled() {
            }
        }

        @ConditionalOnMissingClass(value={"org.springframework.retry.support.RetryTemplate"})
        static class RetryTemplateMissing {
            RetryTemplateMissing() {
            }
        }
    }

    @AutoConfiguration
    @Conditional(value={RetryMissingOrDisabledCondition.class})
    static class LoadBalancerInterceptorConfig {
        LoadBalancerInterceptorConfig() {
        }

        @Bean
        public LoadBalancerInterceptor loadBalancerInterceptor(LoadBalancerClient loadBalancerClient, LoadBalancerRequestFactory requestFactory) {
            return new LoadBalancerInterceptor(loadBalancerClient, requestFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        public RestTemplateCustomizer restTemplateCustomizer(LoadBalancerInterceptor loadBalancerInterceptor) {
            return restTemplate -> {
                ArrayList<LoadBalancerInterceptor> list = new ArrayList<LoadBalancerInterceptor>(restTemplate.getInterceptors());
                list.add(loadBalancerInterceptor);
                restTemplate.setInterceptors(list);
            };
        }
    }

    @AutoConfiguration
    static class DeferringLoadBalancerInterceptorConfig {
        DeferringLoadBalancerInterceptorConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public static DeferringLoadBalancerInterceptor deferringLoadBalancerInterceptor(ObjectProvider<BlockingLoadBalancerInterceptor> loadBalancerInterceptorObjectProvider) {
            return new DeferringLoadBalancerInterceptor(loadBalancerInterceptorObjectProvider);
        }

        @Bean
        @ConditionalOnBean(value={DeferringLoadBalancerInterceptor.class})
        @ConditionalOnMissingBean(value={LoadBalancerRestClientBuilderBeanPostProcessor.class})
        static LoadBalancerRestClientBuilderBeanPostProcessor<DeferringLoadBalancerInterceptor> lbRestClientPostProcessor(ObjectProvider<DeferringLoadBalancerInterceptor> loadBalancerInterceptorProvider, ApplicationContext context) {
            return new LoadBalancerRestClientBuilderBeanPostProcessor<DeferringLoadBalancerInterceptor>(loadBalancerInterceptorProvider, context);
        }

        @Bean
        @ConditionalOnBean(value={DeferringLoadBalancerInterceptor.class})
        @ConditionalOnMissingBean(value={LoadBalancerRestTemplateBuilderBeanPostProcessor.class})
        static LoadBalancerRestTemplateBuilderBeanPostProcessor<DeferringLoadBalancerInterceptor> lbRestTemplateBuilderPostProcessor(ObjectProvider<DeferringLoadBalancerInterceptor> loadBalancerInterceptorProvider, ApplicationContext context) {
            return new LoadBalancerRestTemplateBuilderBeanPostProcessor<DeferringLoadBalancerInterceptor>(loadBalancerInterceptorProvider, context);
        }
    }
}

