/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DistinctNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.NormalizeResultSetNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class UnionNode
extends SetOperatorNode {
    private boolean addNewNodesCalled;
    boolean tableConstructor;
    boolean topTableConstructor;

    UnionNode(ResultSetNode resultSetNode, ResultSetNode resultSetNode2, boolean bl, boolean bl2, Properties properties, ContextManager contextManager) throws StandardException {
        super(resultSetNode, resultSetNode2, bl, properties, contextManager);
        this.tableConstructor = bl2;
    }

    void markTopTableConstructor() {
        this.topTableConstructor = true;
    }

    boolean tableConstructor() {
        return this.tableConstructor;
    }

    @Override
    void rejectParameters() throws StandardException {
        if (!this.tableConstructor()) {
            super.rejectParameters();
        }
    }

    @Override
    void setTableConstructorTypes(ResultColumnList resultColumnList) throws StandardException {
        if (this.tableConstructor()) {
            ResultSetNode resultSetNode = this;
            while (resultSetNode instanceof UnionNode) {
                UnionNode unionNode = resultSetNode;
                ((RowResultSetNode)unionNode.rightResultSet).setTableConstructorTypes(resultColumnList);
                resultSetNode = unionNode.leftResultSet;
            }
            ((RowResultSetNode)resultSetNode).setTableConstructorTypes(resultColumnList);
        }
    }

    @Override
    ResultSetNode enhanceRCLForInsert(InsertNode insertNode, boolean bl, int[] nArray) throws StandardException {
        if (this.tableConstructor()) {
            this.leftResultSet = insertNode.enhanceAndCheckForAutoincrement(this.leftResultSet, bl, nArray, false);
            this.rightResultSet = insertNode.enhanceAndCheckForAutoincrement(this.rightResultSet, bl, nArray, false);
            if (!bl || this.getResultColumns().size() < insertNode.resultColumnList.size()) {
                this.setResultColumns(this.getRCLForInsert(insertNode, nArray));
            }
            return this;
        }
        return super.enhanceRCLForInsert(insertNode, bl, nArray);
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        if (optimizablePredicateList != null && !this.getCurrentAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = optimizablePredicateList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(optimizablePredicateList.getOptPredicate(i))) continue;
                optimizablePredicateList.removeOptPredicate(i);
            }
        }
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftOptPredicateList(), costEstimate);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightOptPredicateList(), costEstimate);
        CostEstimate costEstimate2 = this.getCostEstimate(optimizer);
        costEstimate2.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        costEstimate2.add(this.rightResultSet.getCostEstimate(), costEstimate2);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, optimizablePredicateList, null, costEstimate, optimizer, costEstimate2);
        optimizer.considerCost(this, optimizablePredicateList, costEstimate2, costEstimate);
        return costEstimate2;
    }

    @Override
    void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.leftResultSet instanceof UnionNode) {
            ((UnionNode)this.leftResultSet).pushExpressions(predicateList);
        } else if (this.leftResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.leftResultSet, true);
        }
        if (this.rightResultSet instanceof UnionNode) {
            ((UnionNode)this.rightResultSet).pushExpressions(predicateList);
        } else if (this.rightResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.rightResultSet, true);
        }
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        Optimizable optimizable = super.modifyAccessPath(jBitSet);
        if (this.addNewNodesCalled) {
            return optimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode resultSetNode = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return resultSetNode;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        FromTable fromTable = this;
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        if (!this.all) {
            if (!this.columnTypesAndLengthsMatch()) {
                fromTable = new NormalizeResultSetNode(fromTable, null, null, false, this.getContextManager());
            }
            fromTable = new DistinctNode(fromTable.genProjectRestrict(), false, this.tableProperties, this.getContextManager());
            ((FromTable)fromTable).setTableNumber(this.tableNumber);
            fromTable.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
            this.all = true;
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (orderByList != null) {
                fromTable = new OrderByNode(fromTable, orderByList, this.tableProperties, this.getContextManager());
            }
            ValueNode valueNode = this.qec.getOffset(i);
            ValueNode valueNode2 = this.qec.getFetchFirst(i);
            if (valueNode == null && valueNode2 == null) continue;
            ResultColumnList resultColumnList = fromTable.getResultColumns().copyListAndObjects();
            resultColumnList.genVirtualColumnNodes(fromTable, fromTable.getResultColumns());
            fromTable = new RowCountNode(fromTable, resultColumnList, valueNode, valueNode2, this.qec.getHasJDBCLimitClause()[i], this.getContextManager());
        }
        return fromTable;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public void bindExpressions(FromList fromList) throws StandardException {
        super.bindExpressions(fromList);
        if (this.topTableConstructor && !this.isInsertSource()) {
            RowResultSetNode rowResultSetNode;
            SetOperatorNode setOperatorNode;
            DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[this.leftResultSet.getResultColumns().size()];
            int n = 0;
            ResultSetNode resultSetNode = this;
            while (resultSetNode instanceof SetOperatorNode) {
                setOperatorNode = resultSetNode;
                rowResultSetNode = (RowResultSetNode)setOperatorNode.rightResultSet;
                n += this.getParamColumnTypes(dataTypeDescriptorArray, rowResultSetNode);
                resultSetNode = setOperatorNode.leftResultSet;
            }
            if ((n += this.getParamColumnTypes(dataTypeDescriptorArray, (RowResultSetNode)resultSetNode)) < dataTypeDescriptorArray.length) {
                throw StandardException.newException("42Y10", new Object[0]);
            }
            resultSetNode = this;
            while (resultSetNode instanceof SetOperatorNode) {
                setOperatorNode = resultSetNode;
                rowResultSetNode = (RowResultSetNode)setOperatorNode.rightResultSet;
                this.setParamColumnTypes(dataTypeDescriptorArray, rowResultSetNode);
                resultSetNode = setOperatorNode.leftResultSet;
            }
            this.setParamColumnTypes(dataTypeDescriptorArray, (RowResultSetNode)resultSetNode);
        }
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.getFinalCostEstimate());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.leftResultSet.generate(activationClassBuilder, methodBuilder);
        if (!this.getResultColumns().isExactTypeAndLengthMatch(this.leftResultSet.getResultColumns())) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            methodBuilder.swap();
            this.generateNormalizationResultSet(activationClassBuilder, methodBuilder, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        this.rightResultSet.generate(activationClassBuilder, methodBuilder);
        if (!this.getResultColumns().isExactTypeAndLengthMatch(this.rightResultSet.getResultColumns())) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            methodBuilder.swap();
            this.generateNormalizationResultSet(activationClassBuilder, methodBuilder, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getUnionResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 5);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        CostEstimate costEstimate = this.leftResultSet.getFinalCostEstimate();
        CostEstimate costEstimate2 = this.rightResultSet.getFinalCostEstimate();
        this.setCandidateFinalCostEstimate(this.getNewCostEstimate());
        this.getCandidateFinalCostEstimate().setCost(costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount() + costEstimate2.singleScanRowCount());
        this.getCandidateFinalCostEstimate().add(costEstimate2, this.getCandidateFinalCostEstimate());
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    String getOperatorName() {
        return "UNION";
    }
}

