/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.impl.store.access.sort.SortScan;
import org.apache.derby.shared.common.error.StandardException;

public class MergeScan
extends SortScan {
    protected SortBuffer sortBuffer;
    protected Vector<Long> mergeRuns;
    protected StreamContainerHandle[] openScans;
    private SortObserver sortObserver;

    MergeScan(MergeSort mergeSort, TransactionManager transactionManager, SortBuffer sortBuffer, Vector<Long> vector, SortObserver sortObserver, boolean bl) {
        super(mergeSort, transactionManager, bl);
        this.sortBuffer = sortBuffer;
        this.mergeRuns = vector;
        this.tran = transactionManager;
        this.sortObserver = sortObserver;
    }

    @Override
    public boolean next() throws StandardException {
        this.current = this.sortBuffer.removeFirst();
        if (this.current != null) {
            this.mergeARow(this.sortBuffer.getLastAux());
        }
        return this.current != null;
    }

    @Override
    public void close() {
        if (this.openScans != null) {
            for (int i = 0; i < this.openScans.length; ++i) {
                if (this.openScans[i] != null) {
                    this.openScans[i].close();
                }
                this.openScans[i] = null;
            }
            this.openScans = null;
        }
        if (this.sort != null) {
            this.sort.doneScanning(this, this.sortBuffer, this.mergeRuns);
            this.sortBuffer = null;
            this.mergeRuns = null;
        }
        super.close();
    }

    @Override
    public boolean closeForEndTransaction(boolean bl) {
        if (!this.hold || bl) {
            this.close();
            return true;
        }
        return false;
    }

    public boolean init(TransactionManager transactionManager) throws StandardException {
        this.sortBuffer.reset();
        this.openScans = new StreamContainerHandle[this.mergeRuns.size()];
        if (this.openScans == null) {
            return false;
        }
        int n = 0;
        Enumeration<Long> enumeration = this.mergeRuns.elements();
        while (enumeration.hasMoreElements()) {
            long l = enumeration.nextElement();
            Transaction transaction = transactionManager.getRawStoreXact();
            int n2 = -1;
            this.openScans[n++] = transaction.openStreamContainer(n2, l, this.hold);
        }
        for (n = 0; n < this.openScans.length; ++n) {
            this.mergeARow(n);
        }
        return true;
    }

    void mergeARow(int n) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        do {
            if (!this.openScans[n].fetchNext(dataValueDescriptorArray = this.sortObserver.getArrayClone())) {
                this.openScans[n].close();
                this.openScans[n] = null;
                return;
            }
            this.sortBuffer.setNextAux(n);
        } while (this.sortBuffer.insert(dataValueDescriptorArray) == 1);
    }
}

