/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;

public class HashFunctionPartitioner
implements KeyPartitioner,
Cloneable {
    private Hash hashFunction;
    private int numSegments;
    private int segmentSize;

    public HashFunctionPartitioner() {
    }

    public HashFunctionPartitioner(int numSegments) {
        this.init(numSegments);
    }

    @Override
    public void init(HashConfiguration configuration) {
        Objects.requireNonNull(configuration);
        this.init(configuration.numSegments());
    }

    @Override
    public void init(KeyPartitioner other) {
        if (other instanceof HashFunctionPartitioner) {
            HashFunctionPartitioner o = (HashFunctionPartitioner)other;
            if (o.numSegments > 0) {
                this.init(o.numSegments);
            }
        }
    }

    private void init(int numSegments) {
        if (numSegments <= 0) {
            throw new IllegalArgumentException("numSegments must be strictly positive");
        }
        this.hashFunction = MurmurHash3.getInstance();
        this.numSegments = numSegments;
        this.segmentSize = Util.getSegmentSize((int)numSegments);
    }

    @Override
    public int getSegment(Object key) {
        return (this.hashFunction.hash(key) & Integer.MAX_VALUE) / this.segmentSize;
    }

    public Hash getHash() {
        return this.hashFunction;
    }

    public List<Integer> getSegmentEndHashes() {
        ArrayList<Integer> hashes = new ArrayList<Integer>(this.numSegments);
        for (int i = 0; i < this.numSegments; ++i) {
            hashes.add((i + 1) % this.numSegments * this.segmentSize);
        }
        return hashes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashFunctionPartitioner that = (HashFunctionPartitioner)o;
        if (this.numSegments != that.numSegments) {
            return false;
        }
        return Objects.equals(this.hashFunction, that.hashFunction);
    }

    public int hashCode() {
        int result = this.hashFunction != null ? this.hashFunction.hashCode() : 0;
        result = 31 * result + this.numSegments;
        return result;
    }

    public String toString() {
        return "HashFunctionPartitioner{hashFunction=" + String.valueOf(this.hashFunction) + ", ns=" + this.numSegments + "}";
    }
}

