/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DigestingParser
extends ParserDecorator {
    private final Digester digester;
    private final boolean skipContainerDocument;

    public DigestingParser(Parser parser, Digester digester, boolean skipContainerDocument) {
        super(parser);
        this.digester = digester;
        this.skipContainerDocument = skipContainerDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TemporaryResources tmp = new TemporaryResources();
        TikaInputStream tis = TikaInputStream.get(stream, tmp, metadata);
        try {
            if (this.shouldDigest(metadata)) {
                this.digester.digest((InputStream)((Object)tis), metadata, context);
            }
            super.parse((InputStream)((Object)tis), handler, metadata, context);
        }
        finally {
            tmp.dispose();
        }
    }

    private boolean shouldDigest(Metadata metadata) {
        if (this.digester == null) {
            return false;
        }
        if (!this.skipContainerDocument) {
            return true;
        }
        Integer parseDepth = metadata.getInt(TikaCoreProperties.EMBEDDED_DEPTH);
        return parseDepth != null && parseDepth != 0;
    }

    public static interface Encoder {
        public String encode(byte[] var1);
    }

    public static interface Digester {
        public void digest(InputStream var1, Metadata var2, ParseContext var3) throws IOException;
    }

    public static interface DigesterFactory {
        public Digester build();

        public void setSkipContainerDocument(boolean var1);

        public boolean isSkipContainerDocument();
    }
}

