/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.secretmanager;

import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import org.springframework.cloud.config.server.environment.GoogleSecretManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.RepositoryException;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleConfigProvider;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretManagerAccessStrategy;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretManagerV1AccessStrategy;
import org.springframework.web.client.RestTemplate;

public final class GoogleSecretManagerAccessStrategyFactory {
    private GoogleSecretManagerAccessStrategyFactory() {
        throw new IllegalStateException("Can't instantiate an utility class");
    }

    public static GoogleSecretManagerAccessStrategy forVersion(RestTemplate rest, GoogleConfigProvider configProvider, GoogleSecretManagerEnvironmentProperties properties) {
        switch (properties.getVersion()) {
            case 1: {
                try {
                    return new GoogleSecretManagerV1AccessStrategy(rest, configProvider, properties.getServiceAccount());
                }
                catch (Exception e) {
                    throw new RepositoryException("Cannot create service client", e);
                }
            }
        }
        throw new IllegalArgumentException("No support for given Google Secret manager backend version " + properties.getVersion());
    }

    public static GoogleSecretManagerAccessStrategy forVersion(RestTemplate rest, GoogleConfigProvider configProvider, GoogleSecretManagerEnvironmentProperties properties, SecretManagerServiceClient client) {
        switch (properties.getVersion()) {
            case 1: {
                return new GoogleSecretManagerV1AccessStrategy(rest, configProvider, client);
            }
        }
        throw new IllegalArgumentException("No support for given Google Secret manager backend version " + properties.getVersion());
    }
}

