/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Fallback;
import org.springframework.context.annotation.Role;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerAfterReactiveMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeReactiveMethodInterceptor;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.PostAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.PostFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.security.authorization.method.PreAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.PreFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.method.configuration.DeferringMethodInterceptor;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;

@Configuration(value="_reactiveMethodSecurityConfiguration", proxyBeanMethods=false)
final class ReactiveAuthorizationManagerMethodSecurityConfiguration
implements AopInfrastructureBean,
ApplicationContextAware {
    private static final Pointcut preFilterPointcut = new PreFilterAuthorizationReactiveMethodInterceptor().getPointcut();
    private static final Pointcut preAuthorizePointcut = AuthorizationManagerBeforeReactiveMethodInterceptor.preAuthorize().getPointcut();
    private static final Pointcut postAuthorizePointcut = AuthorizationManagerAfterReactiveMethodInterceptor.postAuthorize().getPointcut();
    private static final Pointcut postFilterPointcut = new PostFilterAuthorizationReactiveMethodInterceptor().getPointcut();
    private PreFilterAuthorizationReactiveMethodInterceptor preFilterMethodInterceptor = new PreFilterAuthorizationReactiveMethodInterceptor();
    private PreAuthorizeReactiveAuthorizationManager preAuthorizeAuthorizationManager = new PreAuthorizeReactiveAuthorizationManager();
    private PostAuthorizeReactiveAuthorizationManager postAuthorizeAuthorizationManager = new PostAuthorizeReactiveAuthorizationManager();
    private PostFilterAuthorizationReactiveMethodInterceptor postFilterMethodInterceptor = new PostFilterAuthorizationReactiveMethodInterceptor();
    private final AuthorizationManagerBeforeReactiveMethodInterceptor preAuthorizeMethodInterceptor;
    private final AuthorizationManagerAfterReactiveMethodInterceptor postAuthorizeMethodInterceptor;

    @Autowired(required=false)
    ReactiveAuthorizationManagerMethodSecurityConfiguration(MethodSecurityExpressionHandler expressionHandler, ObjectProvider<ObjectPostProcessor<ReactiveAuthorizationManager<MethodInvocation>>> preAuthorizePostProcessor, ObjectProvider<ObjectPostProcessor<ReactiveAuthorizationManager<MethodInvocationResult>>> postAuthorizePostProcessor) {
        if (expressionHandler != null) {
            this.preFilterMethodInterceptor = new PreFilterAuthorizationReactiveMethodInterceptor(expressionHandler);
            this.preAuthorizeAuthorizationManager = new PreAuthorizeReactiveAuthorizationManager(expressionHandler);
            this.postFilterMethodInterceptor = new PostFilterAuthorizationReactiveMethodInterceptor(expressionHandler);
            this.postAuthorizeAuthorizationManager = new PostAuthorizeReactiveAuthorizationManager(expressionHandler);
        }
        ReactiveAuthorizationManager preAuthorize = (ReactiveAuthorizationManager)((ObjectPostProcessor)preAuthorizePostProcessor.getIfUnique(ObjectPostProcessor::identity)).postProcess(this.preAuthorizeAuthorizationManager);
        this.preAuthorizeMethodInterceptor = AuthorizationManagerBeforeReactiveMethodInterceptor.preAuthorize((ReactiveAuthorizationManager)preAuthorize);
        ReactiveAuthorizationManager postAuthorize = (ReactiveAuthorizationManager)((ObjectPostProcessor)postAuthorizePostProcessor.getIfAvailable(ObjectPostProcessor::identity)).postProcess(this.postAuthorizeAuthorizationManager);
        this.postAuthorizeMethodInterceptor = AuthorizationManagerAfterReactiveMethodInterceptor.postAuthorize((ReactiveAuthorizationManager)postAuthorize);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.preAuthorizeAuthorizationManager.setApplicationContext(context);
        this.postAuthorizeAuthorizationManager.setApplicationContext(context);
    }

    @Autowired(required=false)
    void setTemplateDefaults(PrePostTemplateDefaults templateDefaults) {
        this.preFilterMethodInterceptor.setTemplateDefaults(templateDefaults);
        this.preAuthorizeAuthorizationManager.setTemplateDefaults(templateDefaults);
        this.postAuthorizeAuthorizationManager.setTemplateDefaults(templateDefaults);
        this.postFilterMethodInterceptor.setTemplateDefaults(templateDefaults);
    }

    @Autowired(required=false)
    void setTemplateDefaults(AnnotationTemplateExpressionDefaults templateDefaults) {
        this.preFilterMethodInterceptor.setTemplateDefaults(templateDefaults);
        this.preAuthorizeAuthorizationManager.setTemplateDefaults(templateDefaults);
        this.postAuthorizeAuthorizationManager.setTemplateDefaults(templateDefaults);
        this.postFilterMethodInterceptor.setTemplateDefaults(templateDefaults);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor preFilterAuthorizationMethodInterceptor(ObjectProvider<ReactiveAuthorizationManagerMethodSecurityConfiguration> _reactiveMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<PreFilterAuthorizationReactiveMethodInterceptor>(preFilterPointcut, () -> ((ReactiveAuthorizationManagerMethodSecurityConfiguration)_reactiveMethodSecurityConfiguration.getObject()).preFilterMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor preAuthorizeAuthorizationMethodInterceptor(ObjectProvider<ReactiveAuthorizationManagerMethodSecurityConfiguration> _reactiveMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<AuthorizationManagerBeforeReactiveMethodInterceptor>(preAuthorizePointcut, () -> ((ReactiveAuthorizationManagerMethodSecurityConfiguration)_reactiveMethodSecurityConfiguration.getObject()).preAuthorizeMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor postFilterAuthorizationMethodInterceptor(ObjectProvider<ReactiveAuthorizationManagerMethodSecurityConfiguration> _reactiveMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<PostFilterAuthorizationReactiveMethodInterceptor>(postFilterPointcut, () -> ((ReactiveAuthorizationManagerMethodSecurityConfiguration)_reactiveMethodSecurityConfiguration.getObject()).postFilterMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor postAuthorizeAuthorizationMethodInterceptor(ObjectProvider<ReactiveAuthorizationManagerMethodSecurityConfiguration> _reactiveMethodSecurityConfiguration) {
        return new DeferringMethodInterceptor<AuthorizationManagerAfterReactiveMethodInterceptor>(postAuthorizePointcut, () -> ((ReactiveAuthorizationManagerMethodSecurityConfiguration)_reactiveMethodSecurityConfiguration.getObject()).postAuthorizeMethodInterceptor);
    }

    @Bean
    @Role(value=2)
    @Fallback
    static DefaultMethodSecurityExpressionHandler methodSecurityExpressionHandler(@Autowired(required=false) GrantedAuthorityDefaults grantedAuthorityDefaults) {
        DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();
        if (grantedAuthorityDefaults != null) {
            handler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
        }
        return handler;
    }
}

