/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import ai.digital.configuration.central.deploy.ClientProperties;
import com.xebialabs.deployit.filter.CsrfHeaderFilter;
import com.xebialabs.xldeploy.auth.oidc.web.XlDeployLoginFormFilter;
import com.xebialabs.xldeploy.authentication.oidc.conf.DeploySecurityConfig;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import scala.reflect.ScalaSignature;

@ConditionalOnProperty(name={"deploy.server.security.auth.provider"}, havingValue="oidc")
@Configuration
@EnableWebSecurity
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\u0006\r\u0001eAQA\b\u0001\u0005\u0002}A\u0011\"\t\u0001A\u0002\u0003\u0007I\u0011\u0001\u0012\t\u0013E\u0002\u0001\u0019!a\u0001\n\u0003\u0011\u0004\"C\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003$\u0011\u001dY\u0005A1A\u0005\n1Ca!\u0016\u0001!\u0002\u0013i\u0005\"\u0002,\u0001\t\u00039\u0006bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007\u0013\u0001\u0004R3qY>L8i\u001d:g'\u0016\u001cWO]5us\u000e{gNZ5h\u0015\tia\"\u0001\u0003d_:4'BA\b\u0011\u0003\u0011y\u0017\u000eZ2\u000b\u0005E\u0011\u0012AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003'Q\t\u0001\u0002\u001f7eKBdw.\u001f\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005maR\"\u0001\u0007\n\u0005ua!\u0001\u0006#fa2|\u0017pU3dkJLG/_\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u00111\u0004A\u0001\u0014G2LWM\u001c;D_:4\u0017nZ;sCRLwN\\\u000b\u0002GA\u0011AeL\u0007\u0002K)\u0011aeJ\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005!J\u0013aB2f]R\u0014\u0018\r\u001c\u0006\u0003U-\nQbY8oM&<WO]1uS>t'B\u0001\u0017.\u0003\u001d!\u0017nZ5uC2T\u0011AL\u0001\u0003C&L!\u0001M\u0013\u0003!\rc\u0017.\u001a8u!J|\u0007/\u001a:uS\u0016\u001c\u0018aF2mS\u0016tGoQ8oM&<WO]1uS>tw\fJ3r)\t\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0003V]&$\bb\u0002\u001e\u0004\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0014\u0001F2mS\u0016tGoQ8oM&<WO]1uS>t\u0007\u0005\u000b\u0002\u0005{A\u0011a(S\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u000bC:tw\u000e^1uS>t'B\u0001\"D\u0003\u001d1\u0017m\u0019;pefT!\u0001R#\u0002\u000b\t,\u0017M\\:\u000b\u0005\u0019;\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003!\u000b1a\u001c:h\u0013\tQuHA\u0005BkR|w/\u001b:fI\u00061\u0001O]3gSb,\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u0019\u0019FO]5oO\u00069\u0001O]3gSb\u0004\u0013!J:fGV\u0014\u0018\u000e^=GS2$XM]\"iC&t7i\u001d:g'\u0016\u001cWO]5us\u000e{gNZ5h)\tA\u0006\r\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006\u0019q/\u001a2\u000b\u0005u+\u0015\u0001C:fGV\u0014\u0018\u000e^=\n\u0005}S&aE*fGV\u0014\u0018\u000e^=GS2$XM]\"iC&t\u0007\"B1\b\u0001\u0004\u0011\u0017\u0001\u00025uiB\u0004\"a\u00196\u000e\u0003\u0011T!!\u001a4\u0002\u0011\t,\u0018\u000e\u001c3feNT!aW4\u000b\u0005\u0001C'BA5]\u0003\u0019\u0019wN\u001c4jO&\u00111\u000e\u001a\u0002\r\u0011R$\boU3dkJLG/\u001f\u0015\u0003\u000f5\u0004\"A\u001c:\u000e\u0003=T!\u0001\u00119\u000b\u0005E,\u0015aB2p]R,\u0007\u0010^\u0005\u0003g>\u0014AAQ3b]\"\"q!\u001e?~!\t1(0D\u0001x\u0015\t\u0001\u0005P\u0003\u0002z\u000b\u0006!1m\u001c:f\u0013\tYxOA\u0003Pe\u0012,'/A\u0003wC2,X-H\u0001\u0002Q\u00119q0!\b\u0011\u000bQ\n\t!!\u0002\n\u0007\u0005\rQG\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u000f\t9B\u0004\u0003\u0002\n\u0005Ma\u0002BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0001$\u0001\u0004=e>|GOP\u0005\u0002m%\u0019\u0011QC\u001b\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005%)\u0005pY3qi&|gNC\u0002\u0002\u0016U\ntAHA\u0010\u0003[\tI\u0006\u0005\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003K\u00012!a\u00036\u0013\r\t9#N\u0001\u0007!J,G-\u001a4\n\u0007Q\u000bYCC\u0002\u0002(U\n\u0014bIA\u0018\u0003o\ty%!\u000f\u0016\t\u0005E\u00121G\u000b\u0003\u0003?!q!!\u000e\u0019\u0005\u0004\tyDA\u0001U\u0013\u0011\tI$a\u000f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\ti$N\u0001\u0007i\"\u0014xn^:\u0012\t\u0005\u0005\u0013q\t\t\u0004i\u0005\r\u0013bAA#k\t9aj\u001c;iS:<\u0007\u0003BA%\u0003\u0017r1\u0001NA\n\u0013\u0011\ti%a\u0007\u0003\u0013QC'o\\<bE2,\u0017'C\u0012\u0002R\u0005M\u0013QKA\u001f\u001d\r!\u00141K\u0005\u0004\u0003{)\u0014'\u0002\u00125k\u0005]#!B:dC2\f\u0017g\u0001\u0014\u0002\u0006\u0005\u00192m\u001d:g\u0019><\u0017N\u001c$pe64\u0015\u000e\u001c;feR\u0011\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)\u00191,!\u001a\u000b\u0007=\t9GC\u0002\u0002jI\tA!Y;uQ&!\u0011QNA2\u0005]AF\u000eR3qY>LHj\\4j]\u001a{'/\u001c$jYR,'/\u0001\u0007m_\u001e|W\u000f\u001e$jYR,'/\u0006\u0002\u0002tA!\u0011QOA?\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014A\u00027pO>,HO\u0003\u0002\u00125&!\u0011qPA<\u00051aunZ8vi\u001aKG\u000e^3s\u0003e9XMY\"te\u001a\u001cVmY;sSRL8)^:u_6L'0\u001a:\u0016\u0005\u0005\u0015\u0005\u0003BAD\u0003\u0017k!!!#\u000b\u0005)2\u0017\u0002BAG\u0003\u0013\u0013QcV3c'\u0016\u001cWO]5us\u000e+8\u000f^8nSj,'\u000f\u000b\u0002\u000b[\"Z\u0001!a%\u0002(\u0006%\u0016qVAY!\u0011\t)*a)\u000e\u0005\u0005]%\u0002BAM\u00037\u000b\u0011bY8oI&$\u0018n\u001c8\u000b\t\u0005u\u0015qT\u0001\u000eCV$xnY8oM&<WO]3\u000b\u0007\u0005\u0005V)\u0001\u0003c_>$\u0018\u0002BAS\u0003/\u0013QcQ8oI&$\u0018n\u001c8bY>s\u0007K]8qKJ$\u00180\u0001\u0003oC6,GFAAVC\t\ti+\u0001\u0013eKBdw.\u001f\u0018tKJ4XM\u001d\u0018tK\u000e,(/\u001b;z]\u0005,H\u000f\u001b\u0018qe>4\u0018\u000eZ3s\u0003-A\u0017M^5oOZ\u000bG.^3\"\u0003=A3\u0001AA[!\rq\u0017qW\u0005\u0004\u0003s{'!D\"p]\u001aLw-\u001e:bi&|g\u000eK\u0002\u0001\u0003{\u0003B!a\"\u0002@&!\u0011\u0011YAE\u0005E)e.\u00192mK^+'mU3dkJLG/\u001f")
public class DeployCsrfSecurityConfig
extends DeploySecurityConfig {
    @Autowired
    private ClientProperties clientConfiguration;
    private final String prefix;

    public ClientProperties clientConfiguration() {
        return this.clientConfiguration;
    }

    public void clientConfiguration_$eq(ClientProperties x$1) {
        this.clientConfiguration = x$1;
    }

    private String prefix() {
        return this.prefix;
    }

    @Bean
    @Order(value=1)
    public SecurityFilterChain securityFilterChainCsrfSecurityConfig(HttpSecurity http) throws Exception {
        http.securityMatchers(securityMatcher -> securityMatcher.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)("/" + this.prefix() + "/**"))}));
        this.configureSecurity(http, this.prefix());
        CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
        requestHandler.setCsrfRequestAttributeName(null);
        return (SecurityFilterChain)http.addFilterAfter((Filter)new CsrfHeaderFilter(this.clientConfiguration()), CsrfFilter.class).addFilterBefore((Filter)this.logoutFilter(), LogoutFilter.class).addFilterBefore((Filter)this.csrfLoginFormFilter(), UsernamePasswordAuthenticationFilter.class).csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)this.tokenRepository()).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler)).build();
    }

    private XlDeployLoginFormFilter csrfLoginFormFilter() {
        return this.buildLoginFormFilter(this.authenticationManager(), (SessionAuthenticationStrategy)this.csrfAuthenticationStrategy());
    }

    private LogoutFilter logoutFilter() {
        LogoutFilter logoutFilter = new LogoutFilter((LogoutSuccessHandler)this.openIdLogoutSuccessHandler(), new LogoutHandler[]{new CsrfLogoutHandler((CsrfTokenRepository)this.tokenRepository()), new CookieClearingLogoutHandler(new String[]{"cookiesToClear", "XSRF-TOKEN"})});
        logoutFilter.setFilterProcessesUrl("/xldeploy/logout");
        return logoutFilter;
    }

    @Bean
    public WebSecurityCustomizer webCsrfSecurityCustomizer() {
        return web -> this.configureSecurity(web, this.prefix());
    }

    public DeployCsrfSecurityConfig() {
        this.prefix = "xldeploy";
    }
}

