/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.hamcrest;

import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.mockito.ArgumentMatcher;

public class HamcrestArgumentMatcher<T>
implements ArgumentMatcher<T> {
    private final Matcher<T> matcher;
    private final Class<?> type;

    public HamcrestArgumentMatcher(Matcher<T> matcher) {
        this(Void.class, matcher);
    }

    public HamcrestArgumentMatcher(Matcher<T> matcher, Class<T> type) {
        this(type, matcher);
    }

    private HamcrestArgumentMatcher(Class<?> type, Matcher<T> matcher) {
        this.type = Objects.requireNonNull(type, "type");
        this.matcher = Objects.requireNonNull(matcher, "matcher");
    }

    @Override
    public boolean matches(Object argument) {
        return this.matcher.matches(argument);
    }

    public String toString() {
        return StringDescription.toString(this.matcher);
    }

    @Override
    public Class<?> type() {
        return this.type;
    }
}

