/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.aeron;

import io.aeron.CncFileDescriptor;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.NoLogging;
import org.apache.pekko.util.Helpers;

public class AeronErrorLog {
    final MappedByteBuffer cncByteBuffer;
    final AtomicBuffer buffer;

    @Deprecated
    public AeronErrorLog(File file) {
        this(file, (LoggingAdapter)NoLogging.getInstance());
    }

    public AeronErrorLog(File file, LoggingAdapter loggingAdapter) {
        this.cncByteBuffer = IoUtil.mapExistingFile((File)file, (String)"cnc");
        UnsafeBuffer unsafeBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)this.cncByteBuffer);
        int n = unsafeBuffer.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        this.buffer = CncFileDescriptor.createErrorLogBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)unsafeBuffer);
        if (CncFileDescriptor.CNC_VERSION != n) {
            loggingAdapter.warning("Aeron CnC version mismatch: compiled version = {}, file version = {}", (Object)CncFileDescriptor.CNC_VERSION, (Object)n);
        }
    }

    public long logErrors(LoggingAdapter loggingAdapter, long l3) {
        AtomicLong atomicLong = new AtomicLong(l3);
        ErrorLogReader.read((AtomicBuffer)this.buffer, (n, l, l2, string) -> {
            loggingAdapter.error(String.format("Aeron error: %d observations from %s to %s for:%n %s", n, Helpers.timestamp((long)l), Helpers.timestamp((long)l2), string));
            atomicLong.set(Math.max(atomicLong.get(), l2));
        }, (long)l3);
        return atomicLong.get();
    }

    public void close() {
        IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
    }
}

