/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.fernflower;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.windup.decompiler.api.ClassDecompileRequest;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.decompiler.AbstractDecompiler;
import org.jboss.windup.decompiler.fernflower.FernFlowerResultSaver;
import org.jboss.windup.decompiler.fernflower.FernflowerJDKLogger;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.util.exception.WindupStopException;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class FernflowerDecompiler
extends AbstractDecompiler {
    private static final Logger LOG = Logger.getLogger(FernflowerDecompiler.class.getName());

    private Map<String, Object> getOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("mpm", 30);
        options.put("dgs", "1");
        options.put("bsm", "1");
        return options;
    }

    private IBytecodeProvider getByteCodeProvider() {
        return new IBytecodeProvider(){

            public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                return InterpreterUtil.getBytes((File)new File(externalPath));
            }
        };
    }

    private FernFlowerResultSaver getResultSaver(List<String> requests, File directory, DecompilationListener listener) {
        return new FernFlowerResultSaver(requests, directory, listener);
    }

    public Logger getLogger() {
        return LOG;
    }

    public Collection<Callable<File>> getDecompileTasks(Map<String, List<ClassDecompileRequest>> requestMap, final DecompilationListener listener) {
        ArrayList<Callable<File>> tasks = new ArrayList<Callable<File>>(requestMap.size());
        for (Map.Entry<String, List<ClassDecompileRequest>> entry : requestMap.entrySet()) {
            final String key = entry.getKey();
            final List<ClassDecompileRequest> requests = entry.getValue();
            Callable<File> task = new Callable<File>(){

                @Override
                public File call() throws Exception {
                    if (listener.isCancelled()) {
                        return null;
                    }
                    ClassDecompileRequest firstRequest = (ClassDecompileRequest)requests.get(0);
                    List<String> classFiles = FernflowerDecompiler.this.pathsFromDecompilationRequests(requests);
                    FernFlowerResultSaver resultSaver = FernflowerDecompiler.this.getResultSaver(FernflowerDecompiler.this.pathsFromDecompilationRequests(requests), firstRequest.getOutputDirectory().toFile(), listener);
                    Fernflower fernflower = new Fernflower(FernflowerDecompiler.this.getByteCodeProvider(), (IResultSaver)resultSaver, FernflowerDecompiler.this.getOptions(), (IFernflowerLogger)new FernflowerJDKLogger());
                    for (ClassDecompileRequest request : requests) {
                        if (listener.isCancelled()) {
                            return null;
                        }
                        fernflower.getStructContext().addSpace(request.getClassFile().toFile(), true);
                    }
                    try {
                        fernflower.decompileContext();
                        if (!resultSaver.isFileSaved()) {
                            listener.decompilationFailed(classFiles, "File was not decompiled!");
                        }
                    }
                    catch (WindupStopException stop) {
                        throw new WindupStopException((Exception)((Object)stop));
                    }
                    catch (Throwable t) {
                        listener.decompilationFailed(classFiles, "Decompilation failed due to: " + t.getMessage());
                        LOG.warning("Decompilation of " + key + " failed due to: " + t.getMessage());
                    }
                    return null;
                }
            };
            tasks.add(task);
        }
        return tasks;
    }

    public DecompilationResult decompileClassFile(Path rootDir, Path classFilePath, Path outputDir) throws DecompilationException {
        final DecompilationResult result = new DecompilationResult();
        DecompilationListener listener = new DecompilationListener(){
            private boolean cancelled;

            public void fileDecompiled(List<String> inputPath, String outputPath) {
                try {
                    result.addDecompiled(inputPath, outputPath);
                }
                catch (WindupStopException stop) {
                    this.cancelled = true;
                    throw new WindupStopException((Exception)((Object)stop));
                }
            }

            public void decompilationFailed(List<String> inputPath, String message) {
                result.addFailure(new DecompilationFailure(message, inputPath, null));
            }

            public void decompilationProcessComplete() {
            }

            public boolean isCancelled() {
                return this.cancelled;
            }
        };
        FernFlowerResultSaver resultSaver = this.getResultSaver(Collections.singletonList(classFilePath.toString()), outputDir.toFile(), listener);
        Fernflower fernflower = new Fernflower(this.getByteCodeProvider(), (IResultSaver)resultSaver, this.getOptions(), (IFernflowerLogger)new FernflowerJDKLogger());
        fernflower.getStructContext().addSpace(classFilePath.toFile(), true);
        fernflower.decompileContext();
        if (!resultSaver.isFileSaved()) {
            listener.decompilationFailed(Collections.singletonList(classFilePath.toString()), "File was not decompiled!");
        }
        return result;
    }

    private List<String> pathsFromDecompilationRequests(List<ClassDecompileRequest> requests) {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassDecompileRequest request : requests) {
            result.add(request.getClassFile().toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecompilationResult decompileArchiveImpl(Path archive, Path outputDir, Filter<ZipEntry> filter, final DecompilationListener delegate) throws DecompilationException {
        JarFile jar;
        final DecompilationResult result = new DecompilationResult();
        DecompilationListener listener = new DecompilationListener(){
            private boolean cancelled;

            public void fileDecompiled(List<String> inputPaths, String outputPath) {
                try {
                    result.addDecompiled(inputPaths, outputPath);
                    delegate.fileDecompiled(inputPaths, outputPath);
                }
                catch (WindupStopException stop) {
                    this.cancelled = true;
                    throw new WindupStopException((Exception)((Object)stop));
                }
            }

            public void decompilationFailed(List<String> inputPath, String message) {
                result.addFailure(new DecompilationFailure(message, inputPath, null));
                delegate.decompilationFailed(inputPath, message);
            }

            public void decompilationProcessComplete() {
                delegate.decompilationProcessComplete();
            }

            public boolean isCancelled() {
                return this.cancelled;
            }
        };
        LOG.info("Decompiling archive '" + archive.toAbsolutePath() + "' to '" + outputDir.toAbsolutePath() + "'");
        try {
            jar = new JarFile(archive.toFile());
        }
        catch (IOException ex) {
            throw new DecompilationException("Can't load .jar: " + archive, (Throwable)ex);
        }
        try {
            AtomicInteger jarEntryCount = new AtomicInteger(0);
            Enumeration<JarEntry> countEnum = jar.entries();
            while (countEnum.hasMoreElements()) {
                countEnum.nextElement();
                jarEntryCount.incrementAndGet();
            }
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                final JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) {
                    jarEntryCount.decrementAndGet();
                    continue;
                }
                if (entry.getName().contains("$")) continue;
                if (filter != null) {
                    Filter.Result filterRes = filter.decide((Object)entry);
                    if (filterRes == Filter.Result.REJECT) {
                        jarEntryCount.decrementAndGet();
                        continue;
                    }
                    if (filterRes == Filter.Result.STOP) break;
                }
                IBytecodeProvider bytecodeProvider = new IBytecodeProvider(){

                    public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                        return InterpreterUtil.getBytes((ZipFile)jar, (ZipEntry)entry);
                    }
                };
                FernFlowerResultSaver resultSaver = this.getResultSaver(Collections.singletonList(entry.getName()), outputDir.toFile(), listener);
                Fernflower fernflower = new Fernflower(bytecodeProvider, (IResultSaver)resultSaver, this.getOptions(), (IFernflowerLogger)new FernflowerJDKLogger());
                fernflower.getStructContext().addSpace(new File(entry.getName()), true);
                fernflower.decompileContext();
                if (resultSaver.isFileSaved()) continue;
                listener.decompilationFailed(Collections.singletonList(entry.getName()), "File was not decompiled!");
            }
            listener.decompilationProcessComplete();
            DecompilationResult decompilationResult = result;
            return decompilationResult;
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException e) {
                LOG.warning("Failed to close jar file: " + jar.getName());
            }
        }
    }
}

