/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal;

import java.lang.instrument.Instrumentation;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.agent.Installer;
import org.mockito.internal.PremainAttach;
import org.mockito.internal.util.StringUtil;

public class PremainAttachAccess {
    public static Instrumentation getInstrumentation() {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Instrumentation instrumentation = PremainAttachAccess.doGetInstrumentation(PremainAttach.class, "getInstrumentation", systemClassLoader);
        if (instrumentation == null) {
            try {
                instrumentation = PremainAttachAccess.doGetInstrumentation(Installer.class, "getInstrumentation", systemClassLoader);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (instrumentation == null) {
            if (ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V21)) {
                System.err.println("Mockito is currently self-attaching to enable the inline-mock-maker. This will no longer work in future releases of the JDK. Please add Mockito as an agent to your build what is described in Mockito's documentation: https://javadoc.io/doc/org.mockito/mockito-core/latest/org/mockito/Mockito.html#0.3");
            }
            instrumentation = ByteBuddyAgent.install();
        }
        if (!instrumentation.isRetransformClassesSupported()) {
            throw new IllegalStateException(StringUtil.join("Mockito requires retransformation for creating inline mocks. This feature is unavailable on the current VM.", "", "You cannot use this mock maker on this VM"));
        }
        return instrumentation;
    }

    private static Instrumentation doGetInstrumentation(Class<?> type, String method, ClassLoader systemClassLoader) {
        try {
            return (Instrumentation)Class.forName(type.getName(), true, systemClassLoader).getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

