/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.UnwrappingEmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.util.concurrent.BlockingManager;

@Scope(value=Scopes.NONE)
public class ReplicableManagerFunctionCommand
implements GlobalRpcCommand {
    public static final byte COMMAND_ID = 60;
    private Function<? super EmbeddedCacheManager, ?> function;
    private Subject subject;

    public ReplicableManagerFunctionCommand() {
    }

    public ReplicableManagerFunctionCommand(Function<? super EmbeddedCacheManager, ?> function, Subject subject) {
        this.function = function;
        this.subject = subject;
    }

    public CompletableFuture<Object> invokeAsync(GlobalComponentRegistry globalComponentRegistry) throws Throwable {
        BlockingManager bm = globalComponentRegistry.getComponent(BlockingManager.class);
        return bm.supplyBlocking(() -> {
            if (this.subject == null) {
                return this.function.apply(new UnwrappingEmbeddedCacheManager(globalComponentRegistry.getCacheManager()));
            }
            return Security.doAs(this.subject, this.function, new UnwrappingEmbeddedCacheManager(globalComponentRegistry.getCacheManager()));
        }, "replicable-manager-function").toCompletableFuture();
    }

    @Override
    public byte getCommandId() {
        return 60;
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.function = (Function)input.readObject();
        this.subject = (Subject)input.readObject();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.function);
        output.writeObject(this.subject);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }
}

