/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.sql.SQLException;
import org.dbunit.IOperationListener;
import org.dbunit.database.IDatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationListener
implements IOperationListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOperationListener.class);

    @Override
    public void connectionRetrieved(IDatabaseConnection connection) {
        logger.debug("connectionCreated(connection={}) - start", (Object)connection);
    }

    @Override
    public void operationSetUpFinished(IDatabaseConnection connection) {
        logger.debug("operationSetUpFinished(connection={}) - start", (Object)connection);
        this.closeConnection(connection);
    }

    @Override
    public void operationTearDownFinished(IDatabaseConnection connection) {
        logger.debug("operationTearDownFinished(connection={}) - start", (Object)connection);
        this.closeConnection(connection);
    }

    private void closeConnection(IDatabaseConnection connection) {
        logger.debug("closeConnection(connection={}) - start", (Object)connection);
        try {
            connection.close();
        }
        catch (SQLException e) {
            logger.warn("Exception while closing the connection: " + e, (Throwable)e);
        }
    }
}

