/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.internal.CachedJdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class JdbcValuesCacheHit
extends AbstractJdbcValues {
    private List<?> cachedResults;
    private final int numberOfRows;
    private final JdbcValuesMapping resolvedMapping;
    private final int[] valueIndexesToCacheIndexes;
    private final int offset;
    private final int resultCount;
    private int position = -1;

    public JdbcValuesCacheHit(List<?> cachedResults, JdbcValuesMapping resolvedMapping) {
        this.cachedResults = cachedResults;
        this.offset = !cachedResults.isEmpty() && cachedResults.get(0) instanceof CachedJdbcValuesMetadata ? 1 : 0;
        this.numberOfRows = cachedResults.size() - this.offset - 1;
        this.resultCount = cachedResults.isEmpty() ? 0 : (Integer)cachedResults.get(cachedResults.size() - 1);
        this.resolvedMapping = resolvedMapping;
        this.valueIndexesToCacheIndexes = resolvedMapping.getValueIndexesToCacheIndexes();
    }

    @Override
    protected boolean processNext(RowProcessingState rowProcessingState) {
        ++this.position;
        if (this.position >= this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    protected boolean processPrevious(RowProcessingState rowProcessingState) {
        --this.position;
        if (this.position >= this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    protected boolean processScroll(int numberOfRows, RowProcessingState rowProcessingState) {
        this.position += numberOfRows;
        if (this.position > this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    protected boolean processPosition(int position, RowProcessingState rowProcessingState) {
        if (position < 0) {
            position = this.numberOfRows + position;
        }
        if (position > this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        this.position = position;
        return true;
    }

    @Override
    public boolean isBeforeFirst(RowProcessingState rowProcessingState) {
        return this.position < 0;
    }

    @Override
    public void beforeFirst(RowProcessingState rowProcessingState) {
        this.position = -1;
    }

    @Override
    public boolean isFirst(RowProcessingState rowProcessingState) {
        return this.position == 0;
    }

    @Override
    public boolean first(RowProcessingState rowProcessingState) {
        this.position = 0;
        return this.numberOfRows > 0;
    }

    @Override
    public boolean isAfterLast(RowProcessingState rowProcessingState) {
        return this.position >= this.numberOfRows;
    }

    @Override
    public void afterLast(RowProcessingState rowProcessingState) {
        this.position = this.numberOfRows;
    }

    @Override
    public boolean isLast(RowProcessingState rowProcessingState) {
        if (this.numberOfRows == 0) {
            return this.position == 0;
        }
        return this.position == this.numberOfRows - 1;
    }

    @Override
    public boolean last(RowProcessingState rowProcessingState) {
        if (this.numberOfRows == 0) {
            this.position = 0;
            return false;
        }
        this.position = this.numberOfRows - 1;
        return true;
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.resolvedMapping;
    }

    @Override
    public boolean usesFollowOnLocking() {
        return true;
    }

    @Override
    public Object getCurrentRowValue(int valueIndex) {
        if (this.position >= this.numberOfRows) {
            return null;
        }
        Object row = this.cachedResults.get(this.position + this.offset);
        if (this.valueIndexesToCacheIndexes == null) {
            return ((Object[])row)[valueIndex];
        }
        if (row instanceof Object[]) {
            return ((Object[])row)[this.valueIndexesToCacheIndexes[valueIndex]];
        }
        assert (this.valueIndexesToCacheIndexes[valueIndex] == 0);
        return row;
    }

    @Override
    public void finishUp(SharedSessionContractImplementor session) {
        this.cachedResults = null;
    }

    @Override
    public void finishRowProcessing(RowProcessingState rowProcessingState, boolean wasAdded) {
    }

    @Override
    public void setFetchSize(int fetchSize) {
    }

    @Override
    public int getResultCountEstimate() {
        return this.resultCount;
    }
}

