/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion.comparer.value;

import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.comparer.value.ValueComparerTemplateBase;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsActualContainingExpectedStringValueComparer
extends ValueComparerTemplateBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected boolean isExpected(ITable expectedTable, ITable actualTable, int rowNum, String columnName, DataType dataType, Object expectedValue, Object actualValue) throws DatabaseUnitException {
        boolean isExpected = expectedValue == null && actualValue == null ? true : (expectedValue == null || actualValue == null ? false : this.isContaining(expectedValue, actualValue));
        return isExpected;
    }

    protected boolean isContaining(Object expectedValue, Object actualValue) throws TypeCastException {
        String expectedValueString = DataType.asString(expectedValue);
        String actualValueString = DataType.asString(actualValue);
        this.log.debug("isContaining: expectedValueString={}, actualValueString={}", (Object)expectedValueString, (Object)actualValueString);
        return actualValueString.contains(expectedValueString);
    }

    @Override
    protected String getFailPhrase() {
        return "not containing";
    }
}

