/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallFinishedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.github.resilience4j.bulkhead.internal.FixedThreadPoolBulkhead;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventPublisher;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public interface ThreadPoolBulkhead
extends AutoCloseable {
    public static <T> Supplier<CompletionStage<T>> decorateCallable(ThreadPoolBulkhead bulkhead, Callable<T> callable) {
        return () -> bulkhead.submit(callable);
    }

    public static <T> Supplier<CompletionStage<T>> decorateSupplier(ThreadPoolBulkhead bulkhead, Supplier<T> supplier) {
        return () -> bulkhead.submit(((Supplier)supplier)::get);
    }

    public static Supplier<CompletionStage<Void>> decorateRunnable(ThreadPoolBulkhead bulkhead, Runnable runnable) {
        return () -> bulkhead.submit(runnable);
    }

    public static ThreadPoolBulkhead ofDefaults(String name) {
        return new FixedThreadPoolBulkhead(name);
    }

    public static ThreadPoolBulkhead of(String name, ThreadPoolBulkheadConfig config) {
        return new FixedThreadPoolBulkhead(name, config);
    }

    public static ThreadPoolBulkhead of(String name, ThreadPoolBulkheadConfig config, Map<String, String> tags) {
        return new FixedThreadPoolBulkhead(name, config, tags);
    }

    public static ThreadPoolBulkhead of(String name, Supplier<ThreadPoolBulkheadConfig> bulkheadConfigSupplier) {
        return new FixedThreadPoolBulkhead(name, bulkheadConfigSupplier);
    }

    public <T> CompletionStage<T> submit(Callable<T> var1);

    public CompletionStage<Void> submit(Runnable var1);

    public String getName();

    public ThreadPoolBulkheadConfig getBulkheadConfig();

    public Metrics getMetrics();

    public Map<String, String> getTags();

    public ThreadPoolBulkheadEventPublisher getEventPublisher();

    default public <T> Supplier<CompletionStage<T>> decorateSupplier(Supplier<T> supplier) {
        return ThreadPoolBulkhead.decorateSupplier(this, supplier);
    }

    default public <T> Supplier<CompletionStage<T>> decorateCallable(Callable<T> callable) {
        return ThreadPoolBulkhead.decorateCallable(this, callable);
    }

    default public Supplier<CompletionStage<Void>> decorateRunnable(Runnable runnable) {
        return ThreadPoolBulkhead.decorateRunnable(this, runnable);
    }

    default public <T> CompletionStage<T> executeSupplier(Supplier<T> supplier) {
        return ThreadPoolBulkhead.decorateSupplier(this, supplier).get();
    }

    default public <T> CompletionStage<T> executeCallable(Callable<T> callable) {
        return ThreadPoolBulkhead.decorateCallable(this, callable).get();
    }

    default public CompletionStage<Void> executeRunnable(Runnable runnable) {
        return ThreadPoolBulkhead.decorateRunnable(this, runnable).get();
    }

    public static interface ThreadPoolBulkheadEventPublisher
    extends EventPublisher<BulkheadEvent> {
        public ThreadPoolBulkheadEventPublisher onCallRejected(EventConsumer<BulkheadOnCallRejectedEvent> var1);

        public ThreadPoolBulkheadEventPublisher onCallPermitted(EventConsumer<BulkheadOnCallPermittedEvent> var1);

        public ThreadPoolBulkheadEventPublisher onCallFinished(EventConsumer<BulkheadOnCallFinishedEvent> var1);
    }

    public static interface Metrics {
        public int getCoreThreadPoolSize();

        public int getThreadPoolSize();

        public int getMaximumThreadPoolSize();

        public int getQueueDepth();

        public int getRemainingQueueCapacity();

        public int getQueueCapacity();

        public int getActiveThreadCount();

        public int getAvailableThreadCount();
    }
}

