/*
 * Decompiled with CFR 0.152.
 */
package kamon.context.generated.binary.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.util.InputMismatchException;

public class LongTag
implements Serializable {
    public static int colferSizeMax = 0x1000000;
    public String key;
    public long value;
    private static final long serialVersionUID = 2L;

    public LongTag() {
        this.init();
    }

    private void init() {
        this.key = "";
    }

    public byte[] marshal(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[Math.min(colferSizeMax, 2048)];
        }
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferOverflowException bufferOverflowException) {
                byArray = new byte[Math.min(colferSizeMax, byArray.length * 4)];
                continue;
            }
            break;
        }
        outputStream.write(byArray, 0, n);
        return byArray;
    }

    public int marshal(byte[] byArray, int n) {
        int n2 = n;
        try {
            int n3;
            if (!this.key.isEmpty()) {
                int n4;
                byArray[n2++] = 0;
                int n5 = ++n2;
                String string = this.key;
                int n6 = string.length();
                for (n3 = 0; n3 < n6; ++n3) {
                    n4 = string.charAt(n3);
                    if (n4 < 128) {
                        byArray[n2++] = (byte)n4;
                        continue;
                    }
                    if (n4 < 2048) {
                        byArray[n2++] = (byte)(0xC0 | n4 >>> 6);
                        byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                        continue;
                    }
                    if (n4 < 55296 || n4 > 57343) {
                        byArray[n2++] = (byte)(0xE0 | n4 >>> 12);
                        byArray[n2++] = (byte)(0x80 | n4 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                        continue;
                    }
                    int n7 = 0;
                    if (++n3 < n6) {
                        n7 = Character.toCodePoint((char)n4, string.charAt(n3));
                    }
                    if (n7 >= 65536 && n7 < 0x200000) {
                        byArray[n2++] = (byte)(0xF0 | n7 >>> 18);
                        byArray[n2++] = (byte)(0x80 | n7 >>> 12 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n7 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n7 & 0x3F);
                        continue;
                    }
                    byArray[n2++] = 63;
                }
                n3 = n2 - n5;
                if (n3 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.LongTag.key size %d exceeds %d UTF-8 bytes", n3, colferSizeMax));
                }
                n6 = n5 - 1;
                if (n3 > 127) {
                    ++n2;
                    for (n4 = n3; n4 >= 16384; n4 >>>= 7) {
                        ++n2;
                    }
                    System.arraycopy(byArray, n5, byArray, n2 - n3, n3);
                    do {
                        byArray[n6++] = (byte)(n3 | 0x80);
                    } while ((n3 >>>= 7) > 127);
                }
                byArray[n6] = (byte)n3;
            }
            if (this.value != 0L) {
                long l = this.value;
                if (l < 0L) {
                    l = -l;
                    byArray[n2++] = -127;
                } else {
                    byArray[n2++] = 1;
                }
                for (n3 = 0; n3 < 8 && (l & 0xFFFFFFFFFFFFFF80L) != 0L; ++n3) {
                    byArray[n2++] = (byte)(l | 0x80L);
                    l >>>= 7;
                }
                byArray[n2++] = (byte)l;
            }
            byArray[n2++] = 127;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 - n > colferSizeMax) {
                throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.LongTag exceeds %d bytes", colferSizeMax));
            }
            if (n2 > byArray.length) {
                throw new BufferOverflowException();
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int unmarshal(byte[] byArray, int n) {
        return this.unmarshal(byArray, n, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmarshal(byte[] byArray, int n, int n2) {
        int n3;
        block17: {
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            n3 = n;
            try {
                int n4;
                byte by = byArray[n3++];
                if (by == 0) {
                    int n5 = 0;
                    int n6 = 0;
                    while (true) {
                        n4 = byArray[n3++];
                        n5 |= (n4 & 0x7F) << n6;
                        if (n6 == 28 || n4 >= 0) break;
                        n6 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.LongTag.key size %d exceeds %d UTF-8 bytes", n5, colferSizeMax));
                    }
                    n6 = n3;
                    n3 += n5;
                    this.key = new String(byArray, n6, n5, StandardCharsets.UTF_8);
                    by = byArray[n3++];
                }
                if (by == 1) {
                    byte by2;
                    long l = 0L;
                    n4 = 0;
                    while (true) {
                        by2 = byArray[n3++];
                        if (n4 == 56 || by2 >= 0) break;
                        l |= ((long)by2 & 0x7FL) << n4;
                        n4 += 7;
                    }
                    this.value = l |= ((long)by2 & 0xFFL) << n4;
                    by = byArray[n3++];
                } else if (by == -127) {
                    byte by3;
                    long l = 0L;
                    n4 = 0;
                    while (true) {
                        by3 = byArray[n3++];
                        if (n4 == 56 || by3 >= 0) break;
                        l |= ((long)by3 & 0x7FL) << n4;
                        n4 += 7;
                    }
                    this.value = -(l |= ((long)by3 & 0xFFL) << n4);
                    by = byArray[n3++];
                }
                if (by != 127) {
                    throw new InputMismatchException(String.format("colfer: unknown header at byte %d", n3 - 1));
                }
                if (n3 <= n2 || n2 - n >= colferSizeMax) break block17;
            }
            catch (Throwable throwable) {
                if (n3 > n2 && n2 - n < colferSizeMax) {
                    throw new BufferUnderflowException();
                }
                if (n3 < 0 || n3 - n > colferSizeMax) {
                    throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.LongTag exceeds %d bytes", colferSizeMax));
                }
                if (n3 > n2) {
                    throw new BufferUnderflowException();
                }
                throw throwable;
            }
            throw new BufferUnderflowException();
        }
        if (n3 < 0 || n3 - n > colferSizeMax) {
            throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.LongTag exceeds %d bytes", colferSizeMax));
        }
        if (n3 > n2) {
            throw new BufferUnderflowException();
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                byArray = new byte[4 * byArray.length];
                continue;
            }
            break;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray, 0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.init();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.unmarshal(byArray, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public LongTag withKey(String string) {
        this.key = string;
        return this;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public LongTag withValue(long l) {
        this.value = l;
        return this;
    }

    public final int hashCode() {
        int n = 1;
        if (this.key != null) {
            n = 31 * n + this.key.hashCode();
        }
        n = 31 * n + (int)(this.value ^ this.value >>> 32);
        return n;
    }

    public final boolean equals(Object object) {
        return object instanceof LongTag && this.equals((LongTag)object);
    }

    public final boolean equals(LongTag longTag) {
        if (longTag == null) {
            return false;
        }
        if (longTag == this) {
            return true;
        }
        return longTag.getClass() == LongTag.class && (this.key == null ? longTag.key == null : this.key.equals(longTag.key)) && this.value == longTag.value;
    }

    public static class Unmarshaller {
        protected InputStream in;
        public byte[] buf;
        protected int offset;
        protected int i;

        public Unmarshaller(InputStream inputStream, byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                byArray = new byte[Math.min(colferSizeMax, 2048)];
            }
            this.buf = byArray;
            this.reset(inputStream);
        }

        public void reset(InputStream inputStream) {
            if (this.i != this.offset) {
                throw new IllegalStateException("colfer: pending data");
            }
            this.in = inputStream;
            this.offset = 0;
            this.i = 0;
        }

        public LongTag next() throws IOException {
            if (this.in == null) {
                return null;
            }
            while (true) {
                if (this.i > this.offset) {
                    try {
                        LongTag longTag = new LongTag();
                        this.offset = longTag.unmarshal(this.buf, this.offset, this.i);
                        return longTag;
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (this.i == this.buf.length) {
                    byte[] byArray = this.buf;
                    if (this.offset == 0) {
                        this.buf = new byte[Math.min(colferSizeMax, this.buf.length * 4)];
                    }
                    System.arraycopy(byArray, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert (this.i < this.buf.length);
                int n = this.in.read(this.buf, this.i, this.buf.length - this.i);
                if (n < 0) {
                    if (this.i > this.offset) {
                        throw new InputMismatchException("colfer: pending data with EOF");
                    }
                    return null;
                }
                assert (n > 0);
                this.i += n;
            }
        }
    }
}

